"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTreeNodesFromPipelines = void 0;
var _react = _interopRequireDefault(require("react"));
var _constants = require("../constants");
var _tree_node_labels = require("../tree_node_labels");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/packages/shared/ingest-pipelines/src/components/pipeline_structure_tree/create_tree_nodes/create_tree_nodes.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * This function takes a {@link PipelineTreeNode} tree of pipeline names, traverses it
 * recursively, and returns a Node tree that can be passed to an {@link EuiTreeView}.
 */
const createTreeNodesFromPipelines = (treeNode, selectedPipeline, clickTreeNode, clickMorePipelines, level = 1) => {
  const currentNode = {
    id: treeNode.pipelineName,
    label: /*#__PURE__*/_react.default.createElement(_tree_node_labels.PipelineTreeNodeLabel, {
      pipelineName: treeNode.pipelineName,
      isManaged: treeNode.isManaged,
      isDeprecated: treeNode.isDeprecated,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 28,
        columnNumber: 7
      }
    }),
    'data-test-subj': `pipelineTreeNode-${treeNode.pipelineName}-moreChildrenPipelines`,
    className: (level === 1 ? 'cssTreeNode-root' : 'cssTreeNode-children') + (treeNode.pipelineName === selectedPipeline ? '--active' : ''),
    children: treeNode.children.length ? [] : undefined,
    isExpanded: level === 1,
    callback: () => clickTreeNode(treeNode.pipelineName)
  };
  if (level === _constants.MAX_TREE_LEVEL) {
    if (treeNode.children.length > 0) {
      const morePipelinesNode = {
        id: `${treeNode.pipelineName}-moreChildrenPipelines`,
        label: /*#__PURE__*/_react.default.createElement(_tree_node_labels.MorePipelinesLabel, {
          count: treeNode.children.length,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 47,
            columnNumber: 16
          }
        }),
        'data-test-subj': `pipelineTreeNode-${treeNode.pipelineName}-moreChildrenPipelines`,
        className: 'cssTreeNode-morePipelines',
        callback: () => clickMorePipelines(treeNode.pipelineName)
      };
      currentNode.children.push(morePipelinesNode);
    }
    return currentNode;
  }
  treeNode.children.forEach(node => {
    currentNode.children.push(createTreeNodesFromPipelines(node, selectedPipeline, clickTreeNode, clickMorePipelines, level + 1));
  });
  return currentNode;
};
exports.createTreeNodesFromPipelines = createTreeNodesFromPipelines;