"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestPipelineFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _test_pipeline_tabs = require("./test_pipeline_tabs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/test_pipeline/test_pipeline_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TestPipelineFlyout = ({
  handleTestPipeline,
  resetTestOutput,
  isRunningTest,
  cachedVerbose,
  cachedDocuments,
  testOutput,
  form,
  validateAndTestPipeline,
  selectedTab,
  setSelectedTab,
  testingError,
  onClose
}) => {
  let tabContent;
  const pipelineTitleId = (0, _eui.useGeneratedHtmlId)();
  if (selectedTab === 'output') {
    tabContent = /*#__PURE__*/_react.default.createElement(_test_pipeline_tabs.OutputTab, {
      handleTestPipeline: handleTestPipeline,
      isRunningTest: isRunningTest,
      cachedVerbose: cachedVerbose,
      cachedDocuments: cachedDocuments,
      testOutput: testOutput,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 7
      }
    });
  } else {
    // default to "Documents" tab
    tabContent = /*#__PURE__*/_react.default.createElement(_test_pipeline_tabs.DocumentsTab, {
      form: form,
      validateAndTestPipeline: validateAndTestPipeline,
      isRunningTest: isRunningTest,
      resetTestOutput: resetTestOutput,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    maxWidth: 550,
    onClose: onClose,
    "data-test-subj": "testPipelineFlyout",
    "aria-labelledby": pipelineTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": "title",
    id: pipelineTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.testPipelineFlyout.title",
    defaultMessage: "Test pipeline",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_test_pipeline_tabs.Tabs, {
    onTabChange: async nextTab => {
      if (nextTab === 'output') {
        // When switching to the output tab,
        // we automatically run the pipeline if documents are defined
        validateAndTestPipeline();
      } else {
        form.reset({
          defaultValue: {
            documents: cachedDocuments
          }
        });
        setSelectedTab(nextTab);
      }
    },
    selectedTab: selectedTab,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }), testingError ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.testPipelineFlyout.executePipelineError",
      defaultMessage: "Unable to execute pipeline",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 17
      }
    }),
    color: "danger",
    iconType: "warning",
    "data-test-subj": "pipelineExecutionError",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 15
    }
  }, testingError.message)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 13
    }
  })) : null, tabContent));
};
exports.TestPipelineFlyout = TestPipelineFlyout;