"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkDirection = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../shared_imports");
var _shared = require("./shared");
var _target_field = require("./common_fields/target_field");
var _ignore_missing_field = require("./common_fields/ignore_missing_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/processor_form/processors/network_direction.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const internalNetworkValues = ['loopback', 'unicast', 'global_unicast', 'multicast', 'interface_local_multicast', 'link_local_unicast', 'link_local_multicast', 'link_local_multicast', 'private', 'public', 'unspecified'];
const fieldsConfig = {
  /* Optional fields config */
  source_ip: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    serializer: _shared.from.emptyStringToUndefined,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.networkDirection.sourceIpLabel', {
      defaultMessage: 'Source IP (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.networkDirection.sourceIpHelpText",
      defaultMessage: "Field containing the source IP address. Defaults to {defaultField}.",
      values: {
        defaultField: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 58,
            columnNumber: 25
          }
        }, 'source.ip')
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 7
      }
    })
  },
  destination_ip: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    serializer: _shared.from.emptyStringToUndefined,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.networkDirection.destinationIpLabel', {
      defaultMessage: 'Destination IP (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.networkDirection.destionationIpHelpText",
      defaultMessage: "Field containing the destination IP address. Defaults to {defaultField}.",
      values: {
        defaultField: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 77,
            columnNumber: 25
          }
        }, 'destination.ip')
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 7
      }
    })
  }
};
const getInternalNetworkConfig = toggleCustom => ({
  internal_networks: {
    path: 'fields.internal_networks',
    euiFieldProps: {
      noSuggestions: false,
      options: internalNetworkValues.map(label => ({
        label
      }))
    },
    config: {
      type: _shared_imports.FIELD_TYPES.COMBO_BOX,
      deserializer: _shared.to.arrayOfStrings,
      serializer: _shared.from.optionalArrayOfStrings,
      fieldsToValidateOnChange: ['fields.internal_networks', 'fields.internal_networks_field'],
      validations: [{
        validator: ({
          value,
          path,
          formData
        }) => {
          if ((0, _lodash.isEmpty)(value) && (0, _lodash.isEmpty)(formData['fields.internal_networks_field'])) {
            return {
              path,
              message: 'A field value is required.'
            };
          }
        }
      }],
      label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.networkDirection.internalNetworksLabel', {
        defaultMessage: 'Internal networks'
      }),
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.pipelineEditor.networkDirection.internalNetworksHelpText",
        defaultMessage: "List of internal networks.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 9
        }
      })
    },
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: toggleCustom,
      "data-test-subj": "toggleCustomField",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.internalNetworkCustomLabel",
      defaultMessage: "Use custom field",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 11
      }
    }))),
    key: 'preset'
  },
  internal_networks_field: {
    path: 'fields.internal_networks_field',
    config: {
      type: _shared_imports.FIELD_TYPES.TEXT,
      serializer: _shared.from.emptyStringToUndefined,
      fieldsToValidateOnChange: ['fields.internal_networks', 'fields.internal_networks_field'],
      validations: [{
        validator: ({
          value,
          path,
          formData
        }) => {
          if ((0, _lodash.isEmpty)(value) && (0, _lodash.isEmpty)(formData['fields.internal_networks'])) {
            return {
              path,
              message: 'A field value is required.'
            };
          }
        }
      }],
      label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.networkDirection.internalNetworksFieldLabel', {
        defaultMessage: 'Internal networks field'
      }),
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.pipelineEditor.networkDirection.internalNetworksFieldHelpText",
        defaultMessage: "Field stating where to read the {field} configuration from.",
        values: {
          field: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 164,
              columnNumber: 20
            }
          }, 'internal_networks')
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 160,
          columnNumber: 9
        }
      })
    },
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: toggleCustom,
      "data-test-subj": "toggleCustomField",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.internalNetworkPredefinedLabel",
      defaultMessage: "Use preset field",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 11
      }
    }))),
    key: 'custom'
  }
});
const NetworkDirection = () => {
  const {
    getFieldDefaultValue
  } = (0, _shared_imports.useFormContext)();
  const isInternalNetowrksFieldDefined = getFieldDefaultValue('fields.internal_networks_field') !== undefined;
  const [isCustom, setIsCustom] = (0, _react.useState)(isInternalNetowrksFieldDefined);
  const toggleCustom = (0, _react.useCallback)(() => {
    setIsCustom(prev => !prev);
  }, []);
  const internalNetworkFieldProps = (0, _react.useMemo)(() => isCustom ? getInternalNetworkConfig(toggleCustom).internal_networks_field : getInternalNetworkConfig(toggleCustom).internal_networks, [isCustom, toggleCustom]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.source_ip,
    component: _shared_imports.Field,
    path: "fields.source_ip",
    "data-test-subj": "sourceIpField",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.destination_ip,
    component: _shared_imports.Field,
    path: "fields.destination_ip",
    "data-test-subj": "destinationIpField",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_target_field.TargetField, {
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.networkDirection.targetFieldHelpText",
      defaultMessage: "Output field. Defaults to {field}.",
      values: {
        field: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 223,
            columnNumber: 22
          }
        }, 'network.direction')
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 219,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, (0, _extends2.default)({}, internalNetworkFieldProps, {
    component: _shared_imports.Field,
    "data-test-subj": "networkDirectionField",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 7
    }
  })), /*#__PURE__*/_react.default.createElement(_ignore_missing_field.IgnoreMissingField, {
    defaultValue: true,
    serializer: _shared.from.undefinedIfValue(true),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 7
    }
  }));
};
exports.NetworkDirection = NetworkDirection;