"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.XJsonToggle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared = require("../processors/shared");
var _shared_imports = require("../../../../../../shared_imports");
var _ = require(".");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/processor_form/field_components/xjson_toggle.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FieldToToggle = ({
  field,
  disabled,
  toggleJson,
  fieldType
}) => {
  if (fieldType === 'text') {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.Field, {
      "data-test-subj": "textValueField",
      field: field,
      euiFieldProps: {
        disabled
      },
      labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 47,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: toggleJson,
        "data-test-subj": "toggleTextField",
        disabled: disabled,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 48,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.pipelineEditor.toggleJson.useJsonFormat",
        defaultMessage: "Define as JSON",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 49,
          columnNumber: 15
        }
      }))),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 7
      }
    });
  }
  if (fieldType === 'combox') {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.ComboBoxField, {
      "data-test-subj": "comboxValueField",
      field: field,
      euiFieldProps: {
        disabled
      },
      labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 67,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: toggleJson,
        "data-test-subj": "toggleTextField",
        disabled: disabled,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 68,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.pipelineEditor.toggleJson.useJsonFormat",
        defaultMessage: "Define as JSON",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 69,
          columnNumber: 15
        }
      }))),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 7
      }
    });
  }
};
const XJsonToggle = ({
  field,
  disabled = false,
  handleIsJson,
  fieldType
}) => {
  const {
    value,
    setValue
  } = field;
  const [defineAsJson, setDefineAsJson] = (0, _react.useState)(undefined);
  const toggleJson = (0, _react.useCallback)(() => {
    const defaultValue = fieldType === 'text' ? '' : [];
    const newValueIsJson = !defineAsJson;
    setValue(newValueIsJson ? '{}' : defaultValue);
    setDefineAsJson(newValueIsJson);
    handleIsJson(newValueIsJson);
  }, [defineAsJson, fieldType, handleIsJson, setValue]);
  (0, _react.useEffect)(() => {
    if (defineAsJson === undefined) {
      setDefineAsJson((0, _shared.isXJsonValue)(value));
      handleIsJson((0, _shared.isXJsonValue)(value));
    }
  }, [defineAsJson, handleIsJson, setValue, value]);
  const mustRenderXJsonEditor = (0, _react.useMemo)(() => {
    if (defineAsJson === undefined) {
      return (0, _shared.isXJsonValue)(value);
    }
    return defineAsJson;
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [defineAsJson]);
  return mustRenderXJsonEditor ? /*#__PURE__*/_react.default.createElement(_.XJsonEditor, {
    field: field,
    disabled: disabled,
    editorProps: {
      'data-test-subj': 'jsonValueField',
      height: disabled ? _shared.EDITOR_PX_HEIGHT.extraSmall : _shared.EDITOR_PX_HEIGHT.medium,
      'aria-label': _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.toggleJson.valueAriaLabel', {
        defaultMessage: 'Value editor'
      }),
      options: {
        readOnly: disabled
      },
      labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 128,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: toggleJson,
        "data-test-subj": "toggleJsonField",
        disabled: disabled,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 129,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.pipelineEditor.toggleJson.useTextFormat",
        defaultMessage: "Define as text",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 130,
          columnNumber: 15
        }
      })))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(FieldToToggle, {
    field: field,
    disabled: disabled,
    toggleJson: toggleJson,
    fieldType: fieldType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 5
    }
  });
};
exports.XJsonToggle = XJsonToggle;