"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GradientLegend = void 0;
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/inventory_view/components/waffle/gradient_legend.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const createTickRender = (bounds, formatter) => (rule, index) => {
  const value = rule.value === 0 ? bounds.min : bounds.max * rule.value;
  const style = {
    left: `${rule.value * 100}%`
  };
  const label = formatter(value);
  return /*#__PURE__*/_react.default.createElement(GradientLegendTick, {
    style: style,
    key: `legend-rule-${index}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(GradientLegendTickLine, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(GradientLegendTickLabel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 9
    }
  }, label));
};
const GradientLegend = ({
  legend,
  bounds,
  formatter
}) => {
  const maxValue = legend.rules.reduce((acc, rule) => {
    return acc < rule.value ? rule.value : acc;
  }, 0);
  const colorStops = legend.rules.map(rule => {
    const percent = rule.value / maxValue * 100;
    return `${rule.color} ${percent}%`;
  });
  const style = {
    background: `linear-gradient(to right, ${colorStops})`
  };
  return /*#__PURE__*/_react.default.createElement(GradientLegendContainer, {
    style: style,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, legend.rules.map(createTickRender(bounds, formatter)));
};
exports.GradientLegend = GradientLegend;
const GradientLegendContainer = _styled.default.div`
  position: absolute;
  height: 10px;
  bottom: 0;
  left: 0;
  right: 40px;
`;
const GradientLegendTick = _styled.default.div`
  position: absolute;
  bottom: 0;
  top: -18px;
`;
const GradientLegendTickLine = _styled.default.div`
  position: absolute;
  background-color: ${props => props.theme.euiTheme.colors.backgroundBaseSubdued};
  width: 1px;
  left: 0;
  top: 15px;
  bottom: 0;
  ${GradientLegendTick}:first-child {
    top: 2px;
  }
  ${GradientLegendTick}:last-child {
    top: 2px;
  }
`;
const GradientLegendTickLabel = _styled.default.div`
  position: absolute;
  font-size: ${() => (0, _eui.useEuiFontSize)('xxs').fontSize};
  text-align: center;
  top: 0;
  left: 0;
  white-space: nowrap;
  transform: translate(-50%, 0);
  ${GradientLegendTick}:first-child & {
    padding-left: 5px;
    transform: translate(0, 0);
  }
  ${GradientLegendTick}:last-child & {
    padding-right: 5px;
    transform: translate(-100%, 0);
  }
`;