"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopCategoriesSection = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _loading_overlay_wrapper = require("../../../../../components/loading_overlay_wrapper");
var _top_categories_table = require("./top_categories_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/logs/log_entry_categories/sections/top_categories/top_categories_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TopCategoriesSection = ({
  isLoadingTopCategories = false,
  jobId,
  logViewReference,
  timeRange,
  topCategories,
  sortOptions,
  changeSortOptions
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_loading_overlay_wrapper.LoadingOverlayWrapper, {
    isLoading: isLoadingTopCategories,
    loadingChildren: /*#__PURE__*/_react.default.createElement(LoadingOverlayContent, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 26
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_top_categories_table.TopCategoriesTable, {
    categorizationJobId: jobId,
    logViewReference: logViewReference,
    timeRange: timeRange,
    topCategories: topCategories,
    sortOptions: sortOptions,
    changeSortOptions: changeSortOptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  })));
};
exports.TopCategoriesSection = TopCategoriesSection;
const loadingAriaLabel = _i18n.i18n.translate('xpack.infra.logs.logEntryCategories.topCategoriesSectionLoadingAriaLabel', {
  defaultMessage: 'Loading message categories'
});
const LoadingOverlayContent = () => /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
  size: "xl",
  "aria-label": loadingAriaLabel,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 60,
    columnNumber: 37
  }
});