"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogEntryCategoriesPageProviders = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/logs-data-access-plugin/public");
var _log_analysis = require("../../../../common/log_analysis");
var _setup_flyout = require("../../../components/logging/log_analysis_setup/setup_flyout");
var _source_loading_page = require("../../../components/source_loading_page");
var _log_entry_categories = require("../../../containers/logs/log_analysis/modules/log_entry_categories");
var _use_kibana_space = require("../../../hooks/use_kibana_space");
var _page_log_view_error = require("../shared/page_log_view_error");
var _use_log_ml_job_id_formats_shim = require("../shared/use_log_ml_job_id_formats_shim");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/logs/log_entry_categories/page_providers.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TIMESTAMP_FIELD = '@timestamp';
const DEFAULT_MODULE_SOURCE_CONFIGURATION_ID = 'default'; // NOTE: Left in for legacy reasons, this used to refer to a log view ID (legacy).

const LogEntryCategoriesPageProviders = ({
  children
}) => {
  const {
    logSources,
    isLoadingLogSources,
    isUninitialized,
    hasFailedLoadingLogSources,
    logSourcesError,
    combinedIndices
  } = (0, _public.useLogSourcesContext)();
  const {
    space
  } = (0, _use_kibana_space.useActiveKibanaSpace)();
  const {
    idFormats,
    isLoadingLogAnalysisIdFormats,
    hasFailedLoadingLogAnalysisIdFormats
  } = (0, _use_log_ml_job_id_formats_shim.useLogMlJobIdFormatsShimContext)();

  // This is a rather crude way of guarding the dependent providers against
  // arguments that are only made available asynchronously. Ideally, we'd use
  // React concurrent mode and Suspense in order to handle that more gracefully.
  if (space == null) {
    return null;
  } else if (hasFailedLoadingLogSources || hasFailedLoadingLogAnalysisIdFormats) {
    return /*#__PURE__*/_react.default.createElement(_page_log_view_error.LogSourceErrorPage, {
      errors: logSourcesError !== undefined ? [logSourcesError] : [],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 12
      }
    });
  } else if (isLoadingLogSources || isUninitialized || isLoadingLogAnalysisIdFormats || !idFormats) {
    return /*#__PURE__*/_react.default.createElement(_source_loading_page.SourceLoadingPage, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 12
      }
    });
  } else if (logSources.length > 0) {
    return /*#__PURE__*/_react.default.createElement(_log_entry_categories.LogEntryCategoriesModuleProvider, {
      indexPattern: combinedIndices,
      spaceId: space.id,
      sourceId: DEFAULT_MODULE_SOURCE_CONFIGURATION_ID,
      idFormat: idFormats[_log_analysis.logEntryCategoriesJobType],
      timestampField: TIMESTAMP_FIELD,
      runtimeMappings: {},
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_setup_flyout.LogAnalysisSetupFlyoutStateProvider, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 9
      }
    }, children));
  } else {
    return null;
  }
};
exports.LogEntryCategoriesPageProviders = LogEntryCategoriesPageProviders;