"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DecorateWithTabSwitcherContext = exports.DecorateWithKibanaContext = exports.DecorateWithAssetDetailsStateContext = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _rxjs = require("rxjs");
var _addonActions = require("@storybook/addon-actions");
var _previewApi = require("@storybook/preview-api");
var _common = require("@kbn/logs-shared-plugin/common");
var _reactRouterDom = require("react-router-dom");
var _use_reload_request_time = require("../../../hooks/use_reload_request_time");
var _use_alert_prefill = require("../../../alerting/use_alert_prefill");
var _plugin_config_context = require("../../../containers/plugin_config_context");
var _metrics_source = require("../../../containers/metrics_source");
var _http = require("./context/http");
var _fixtures = require("./context/fixtures");
var _context_providers = require("../context_providers");
var _use_data_views = require("../hooks/use_data_views");
var _use_tab_switcher = require("../hooks/use_tab_switcher");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/__stories__/decorator.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const settings = {
  'dateFormat:scaled': [['', 'HH:mm:ss.SSS']],
  'timepicker:timeDefaults': ['now-15m', 'now']
};
const getSettings = key => settings[key];
const mockDataView = {
  id: 'default',
  getFieldByName: () => 'hostname'
};
const DecorateWithKibanaContext = story => {
  const initialProcesses = (0, _previewApi.useParameter)('apiResponse', {
    mock: 'default'
  });
  const mockServices = {
    application: {
      currentAppId$: (0, _rxjs.of)('infra'),
      navigateToUrl: async url => {
        (0, _addonActions.action)(`Navigate to: ${url}`);
      },
      getUrlForApp: url => url,
      capabilities: {
        maintenanceWindow: {
          show: false
        }
      }
    },
    docLinks: {
      links: {
        observability: {
          guide: 'https://www.elastic.co/guide/en/observability/current/index.html'
        }
      }
    },
    chrome: {
      docTitle: {
        change(newTitle) {
          (0, _addonActions.action)('chrome.docTitle.change')(newTitle);
          return newTitle;
        }
      },
      setBreadcrumbs: () => {},
      getChromeStyle$: () => (0, _rxjs.of)({}),
      setBreadcrumbsAppendExtension: () => () => {}
    },
    data: {
      search: {
        search: (request, options) => {
          return (0, _fixtures.getLogEntries)(request, options);
        },
        session: {
          start: () => 'started',
          state$: {
            closed: false
          }
        }
      },
      query: {
        filterManager: {
          addFilters: () => {},
          removeFilter: () => {}
        }
      }
    },
    dataViews: {
      create: () => Promise.resolve(mockDataView)
    },
    uiActions: {
      getTriggerCompatibleActions: () => {
        return Promise.resolve([]);
      }
    },
    uiSettings: {
      get: () => ({
        key: 'mock',
        defaultOverride: undefined
      })
    },
    triggersActionsUi: {
      getAlertSummaryWidget: () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null)
    },
    charts: {
      theme: {
        useChartsBaseTheme: () => ({})
      }
    },
    settings: {
      client: {
        get$: key => (0, _rxjs.of)(getSettings(key)),
        get: getSettings
      }
    },
    notifications: {
      toasts: {
        add: params => {
          (0, _addonActions.action)('notifications.toats.add')(params);
          return {
            id: 'id'
          };
        }
      }
    },
    http: (0, _http.getHttp)(initialProcesses),
    share: {
      url: {
        locators: {
          get: _id => ({
            navigate: async () => {
              return Promise.resolve();
            },
            getRedirectUrl: args => {
              (0, _addonActions.action)('share.url.locators.getRedirectUrl')(args);
            },
            useUrl: () => ({
              getRedirectUrl: args => {
                (0, _addonActions.action)('share.url.locators.useUrl.getRedirectUrl')(args);
              }
            })
          })
        }
      }
    },
    logsShared: {
      logViews: {
        client: {
          getLogView: () => Promise.resolve({
            id: 'log',
            attributes: _common.defaultLogViewAttributes,
            origin: 'internal'
          }),
          getResolvedLogView: () => Promise.resolve({
            dataViewReference: mockDataView
          })
        }
      }
    },
    lens: {
      navigateToPrefilledEditor: () => {},
      stateHelperApi: () => new Promise(() => {})
    },
    telemetry: {
      reportAssetDetailsFlyoutViewed: () => {},
      reportAssetDetailsPageViewed: () => {},
      reportAssetDashboardLoaded: () => {},
      reportPerformanceMetricEvent: () => {}
    },
    observabilityShared: {
      navigation: {
        PageTemplate: ({
          children
        }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children)
      }
    }
  };
  const config = {
    alerting: {
      inventory_threshold: {
        group_by_page_size: 11
      },
      metric_threshold: {
        group_by_page_size: 11
      }
    },
    enabled: true,
    inventory: {
      compositeSize: 11
    },
    sources: {
      default: {
        fields: {
          message: ['default']
        }
      }
    },
    featureFlags: {
      customThresholdAlertsEnabled: true,
      metricsExplorerEnabled: false,
      osqueryEnabled: true,
      inventoryThresholdAlertRuleEnabled: true,
      metricThresholdAlertRuleEnabled: true,
      logThresholdAlertRuleEnabled: true,
      alertsAndRulesDropdownEnabled: true,
      // to be removed in https://github.com/elastic/kibana/issues/221904
      profilingEnabled: false,
      ruleFormV2Enabled: false
    }
  };
  return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.MemoryRouter, {
    initialEntries: ['/infra/metrics/hosts'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_plugin_config_context.PluginConfigProvider, {
    value: config,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: mockServices,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_metrics_source.SourceProvider, {
    sourceId: "default",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_metrics_source.MetricsDataViewProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_use_reload_request_time.ReloadRequestTimeProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_use_alert_prefill.AlertPrefillProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 19
    }
  }, story()))))))));
};
exports.DecorateWithKibanaContext = DecorateWithKibanaContext;
const DecorateWithAssetDetailsStateContext = story => {
  return /*#__PURE__*/_react.default.createElement(_context_providers.ContextProviders, (0, _extends2.default)({}, _fixtures.assetDetailsProps, {
    dateRange: {
      from: '2023-04-09T11:07:49Z',
      to: '2023-04-09T11:23:49Z'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_use_data_views.DataViewsProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 7
    }
  }, story()));
};
exports.DecorateWithAssetDetailsStateContext = DecorateWithAssetDetailsStateContext;
const DecorateWithTabSwitcherContext = defaultActiveTabId => story => {
  return /*#__PURE__*/_react.default.createElement(_use_tab_switcher.TabSwitcherProvider, {
    defaultActiveTabId: defaultActiveTabId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_use_data_views.DataViewsProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 9
    }
  }, story()));
};
exports.DecorateWithTabSwitcherContext = DecorateWithTabSwitcherContext;