"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Threshold = void 0;
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/alerting/common/components/threshold.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const NO_DATA_VALUE = _i18n.i18n.translate('xpack.infra.alerting.noDataValue', {
  defaultMessage: 'No Data'
});
const THRESHOLD_NO_DATA_TITLE = _i18n.i18n.translate('xpack.infra.alerting.thresholdNoDataTitle', {
  defaultMessage: 'Alert when'
});
const Threshold = ({
  chartProps: {
    theme,
    baseTheme
  },
  comparator,
  id,
  thresholds,
  title,
  value,
  valueFormatter,
  warning
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const color = euiTheme.colors.backgroundBaseDanger;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    style: {
      height: '100%',
      overflow: 'hidden',
      position: 'relative',
      minWidth: '100%'
    },
    hasShadow: false,
    "data-test-subj": `threshold-${thresholds.join('-')}-${value}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: theme,
    baseTheme: baseTheme,
    locale: _i18n.i18n.getLocale(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Metric, {
    id: id,
    data: [[{
      title,
      extra: value ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.infra.alerting.thresholdExtraTitle', {
        values: {
          comparator,
          threshold: thresholds.map(t => valueFormatter(t)).join(' - ')
        },
        defaultMessage: `Alert when {comparator} {threshold}`
      }), /*#__PURE__*/_react.default.createElement("br", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 84,
          columnNumber: 21
        }
      }), warning && _i18n.i18n.translate('xpack.infra.alerting.warningExtraTitle', {
        values: {
          comparator: warning.comparator,
          threshold: warning.thresholds.map(t => valueFormatter(t)).join(' - ')
        },
        defaultMessage: `Warn when {comparator} {threshold}`
      })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, THRESHOLD_NO_DATA_TITLE),
      color,
      value: value !== null && value !== void 0 ? value : NO_DATA_VALUE,
      valueFormatter,
      icon: ({
        width,
        height,
        color: iconColor
      }) => /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        width: width,
        height: height,
        color: iconColor,
        type: "alert",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 101,
          columnNumber: 19
        }
      })
    }]],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  })));
};
exports.Threshold = Threshold;