"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TemplateTypeIndicator = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/template_list/components/template_type_indicator.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const i18nTexts = {
  managed: _i18n.i18n.translate('xpack.idxMgmt.templateBadgeType.managed', {
    defaultMessage: 'Managed'
  }),
  cloudManaged: _i18n.i18n.translate('xpack.idxMgmt.templateBadgeType.cloudManaged', {
    defaultMessage: 'Cloud-managed'
  }),
  system: _i18n.i18n.translate('xpack.idxMgmt.templateBadgeType.system', {
    defaultMessage: 'System'
  })
};
const TemplateTypeIndicator = ({
  templateType
}) => {
  if (templateType === 'default') {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    "data-test-subj": "templateTypeBadge",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }, i18nTexts[templateType]);
};
exports.TemplateTypeIndicator = TemplateTypeIndicator;