"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderBadges = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _rollup = require("@kbn/rollup");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/lib/render_badges.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const renderBadges = (index, extensionsService, onFilterChange) => {
  const badgeLabels = [];
  extensionsService.badges.forEach(indexBadge => {
    const {
      matchIndex,
      label,
      color,
      filterExpression
    } = indexBadge;
    if (matchIndex(index)) {
      const clickHandler = () => {
        if (onFilterChange && filterExpression) {
          onFilterChange(_eui.Query.parse(filterExpression));
        }
      };
      const ariaLabel = _i18n.i18n.translate('xpack.idxMgmt.badgeAriaLabel', {
        defaultMessage: '{label}. Select to filter on this.',
        values: {
          label
        }
      });
      const badge = onFilterChange && filterExpression ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: color,
        onClick: clickHandler,
        onClickAriaLabel: ariaLabel,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 37,
          columnNumber: 11
        }
      }, label) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: color,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 41,
          columnNumber: 11
        }
      }, label);
      const badgeItem =
      // If the badge is for Rollups, add a tooltip with deprecation information
      indexBadge.label === _rollup.ROLLUP_DEPRECATION_BADGE_LABEL ? /*#__PURE__*/_react.default.createElement(_rollup.RollupDeprecationTooltip, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 46,
          columnNumber: 11
        }
      }, badge) : badge;
      badgeLabels.push(/*#__PURE__*/_react.default.createElement(_react.Fragment, {
        key: label,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 50,
          columnNumber: 24
        }
      }, " ", badgeItem));
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 10
    }
  }, badgeLabels);
};
exports.renderBadges = renderBadges;