"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TemplateForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../../common/constants");
var _shared_imports = require("../../../shared_imports");
var _shared = require("../shared");
var _documentation = require("../../services/documentation");
var _section_error = require("../section_error");
var _lib = require("../../../../common/lib");
var _index_templates = require("../index_templates");
var _steps = require("./steps");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/template_form/template_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  stripEmptyFields
} = _shared_imports.serializers;
const {
  FormWizard,
  FormWizardStep
} = _shared_imports.Forms;
const {
  useGlobalFlyout
} = _shared_imports.GlobalFlyout;
const wizardSections = {
  logistics: {
    id: 'logistics',
    label: _i18n.i18n.translate('xpack.idxMgmt.templateForm.steps.logisticsStepName', {
      defaultMessage: 'Logistics'
    })
  },
  components: {
    id: 'components',
    label: _i18n.i18n.translate('xpack.idxMgmt.templateForm.steps.componentsStepName', {
      defaultMessage: 'Component templates'
    })
  },
  settings: {
    id: 'settings',
    label: _i18n.i18n.translate('xpack.idxMgmt.templateForm.steps.settingsStepName', {
      defaultMessage: 'Index settings'
    })
  },
  mappings: {
    id: 'mappings',
    label: _i18n.i18n.translate('xpack.idxMgmt.templateForm.steps.mappingsStepName', {
      defaultMessage: 'Mappings'
    })
  },
  aliases: {
    id: 'aliases',
    label: _i18n.i18n.translate('xpack.idxMgmt.templateForm.steps.aliasesStepName', {
      defaultMessage: 'Aliases'
    })
  },
  review: {
    id: 'review',
    label: _i18n.i18n.translate('xpack.idxMgmt.templateForm.steps.summaryStepName', {
      defaultMessage: 'Review template'
    })
  }
};
const TemplateForm = ({
  title,
  defaultValue,
  isEditing,
  isSaving,
  isLegacy = false,
  saveError,
  clearSaveError,
  onSave,
  history
}) => {
  const [wizardContent, setWizardContent] = (0, _react.useState)(null);
  const {
    addContent: addContentToGlobalFlyout,
    closeFlyout
  } = useGlobalFlyout();
  const simulateTemplateFilters = (0, _react.useRef)({
    mappings: true,
    settings: true,
    aliases: true
  });

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const indexTemplate = defaultValue !== null && defaultValue !== void 0 ? defaultValue : {
    name: '',
    indexPatterns: [],
    dataStream: {},
    indexMode: _constants.STANDARD_INDEX_MODE,
    template: {},
    _kbnMeta: {
      type: 'default',
      hasDatastream: false,
      isLegacy
    },
    allowAutoCreate: _constants.allowAutoCreateRadioIds.NO_OVERWRITE_RADIO_OPTION
  };
  const {
    template: {
      settings,
      mappings,
      aliases,
      data_stream_options: dataStreamOptions
    } = {},
    composedOf,
    _kbnMeta,
    ...logistics
  } = indexTemplate;
  const wizardDefaultValue = {
    logistics,
    settings,
    mappings,
    aliases,
    components: indexTemplate.composedOf
  };
  const i18nTexts = {
    save: isEditing ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.templateForm.saveButtonLabel",
      defaultMessage: "Save template",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 7
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.templateForm.createButtonLabel",
      defaultMessage: "Create template",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 7
      }
    })
  };
  const apiError = saveError ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_section_error.SectionError, {
    title: _i18n.i18n.translate('xpack.idxMgmt.templateForm.saveTemplateError', {
      defaultMessage: 'Unable to create template'
    }),
    error: saveError,
    "data-test-subj": "saveTemplateError",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 7
    }
  })) : null;

  /**
   * If no mappings, settings or aliases are defined, it is better to not send empty
   * object for those values.
   * This method takes care of that and other cleanup of empty fields.
   * @param template The template object to clean up
   */
  const cleanupTemplateObject = template => {
    const outputTemplate = {
      ...template
    };
    if (outputTemplate.template) {
      if (outputTemplate.template.settings === undefined) {
        delete outputTemplate.template.settings;
      }
      if (outputTemplate.template.mappings === undefined) {
        delete outputTemplate.template.mappings;
      }
      if (outputTemplate.template.aliases === undefined) {
        delete outputTemplate.template.aliases;
      }
      if (Object.keys(outputTemplate.template).length === 0) {
        delete outputTemplate.template;
      }
      if (outputTemplate.lifecycle) {
        delete outputTemplate.lifecycle;
      }
    }
    return outputTemplate;
  };
  const buildTemplateObject = (0, _react.useCallback)(initialTemplate => wizardData => {
    const outputTemplate = {
      ...wizardData.logistics,
      _kbnMeta: initialTemplate._kbnMeta,
      deprecated: initialTemplate.deprecated,
      composedOf: wizardData.components,
      template: {
        settings: wizardData.settings,
        mappings: wizardData.mappings,
        aliases: wizardData.aliases,
        lifecycle: wizardData.logistics.lifecycle ? (0, _lib.serializeAsESLifecycle)(wizardData.logistics.lifecycle) : undefined,
        ...(dataStreamOptions && {
          data_stream_options: dataStreamOptions
        })
      },
      ignoreMissingComponentTemplates: initialTemplate.ignoreMissingComponentTemplates
    };
    return cleanupTemplateObject(outputTemplate);
  }, [dataStreamOptions]);
  const onWizardContentChange = (0, _react.useCallback)(content => {
    setWizardContent(content);
  }, []);
  const onSaveTemplate = (0, _react.useCallback)(async wizardData => {
    const template = buildTemplateObject(indexTemplate)(wizardData);

    // We need to strip empty string, otherwise if the "order" or "version"
    // are not set, they will be empty string and ES expect a number for those parameters.
    onSave(stripEmptyFields(template, {
      types: ['string']
    }));
    clearSaveError();
  }, [indexTemplate, buildTemplateObject, onSave, clearSaveError]);
  const getSimulateTemplate = (0, _react.useCallback)(async () => {
    if (!wizardContent) {
      return;
    }
    const isValid = await wizardContent.validate();
    if (!isValid) {
      return;
    }
    const wizardData = wizardContent.getData();
    const template = buildTemplateObject(indexTemplate)(wizardData);
    return template;
  }, [buildTemplateObject, indexTemplate, wizardContent]);
  const onSimulateTemplateFiltersChange = (0, _react.useCallback)(filters => {
    simulateTemplateFilters.current = filters;
  }, []);
  const showPreviewFlyout = () => {
    addContentToGlobalFlyout({
      id: 'simulateTemplate',
      Component: _index_templates.SimulateTemplateFlyoutContent,
      props: {
        getTemplate: getSimulateTemplate,
        onClose: closeFlyout,
        filters: simulateTemplateFilters.current,
        onFiltersChange: onSimulateTemplateFiltersChange
      },
      flyoutProps: _index_templates.simulateTemplateFlyoutProps
    });
  };
  const getRightContentWizardNav = stepId => {
    if (isLegacy) {
      return null;
    }

    // Don't show "Preview template" button on logistics and review steps
    if (stepId === 'logistics' || stepId === 'review') {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      onClick: showPreviewFlyout,
      "data-test-subj": "previewIndexTemplate",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 286,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.templateForm.previewIndexTemplateButtonLabel",
      defaultMessage: "Preview index template",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 287,
        columnNumber: 9
      }
    }));
  };
  const isLegacyIndexTemplate = indexTemplate._kbnMeta.isLegacy === true;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "pageTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 300,
        columnNumber: 33
      }
    }, title),
    bottomBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 302,
      columnNumber: 7
    }
  }), isLegacyIndexTemplate && /*#__PURE__*/_react.default.createElement(_index_templates.LegacyIndexTemplatesDeprecation, {
    history: history,
    showCta: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(FormWizard, {
    defaultValue: wizardDefaultValue,
    onSave: onSaveTemplate,
    isEditing: isEditing,
    isSaving: isSaving,
    apiError: apiError,
    texts: i18nTexts,
    onChange: onWizardContentChange,
    rightContentNav: getRightContentWizardNav,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 310,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(FormWizardStep, {
    id: wizardSections.logistics.id,
    label: wizardSections.logistics.label,
    isRequired: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 320,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_steps.StepLogisticsContainer, {
    isEditing: isEditing,
    isLegacy: indexTemplate._kbnMeta.isLegacy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 325,
      columnNumber: 11
    }
  })), !isLegacyIndexTemplate && /*#__PURE__*/_react.default.createElement(FormWizardStep, {
    id: wizardSections.components.id,
    label: wizardSections.components.label,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 332,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_steps.StepComponentContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 333,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(FormWizardStep, {
    id: wizardSections.settings.id,
    label: wizardSections.settings.label,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 337,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_shared.StepSettingsContainer, {
    esDocsBase: _documentation.documentationService.getEsDocsBase(),
    getTemplateData: buildTemplateObject(indexTemplate),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 338,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(FormWizardStep, {
    id: wizardSections.mappings.id,
    label: wizardSections.mappings.label,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 344,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_shared.StepMappingsContainer, {
    esDocsBase: _documentation.documentationService.getEsDocsBase(),
    getTemplateData: buildTemplateObject(indexTemplate),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 345,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(FormWizardStep, {
    id: wizardSections.aliases.id,
    label: wizardSections.aliases.label,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 351,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_shared.StepAliasesContainer, {
    esDocsBase: _documentation.documentationService.getEsDocsBase(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 352,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(FormWizardStep, {
    id: wizardSections.review.id,
    label: wizardSections.review.label,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 355,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_steps.StepReviewContainer, {
    getTemplateData: buildTemplateObject(indexTemplate),
    dataStreamOptions: dataStreamOptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 356,
      columnNumber: 11
    }
  }))));
};
exports.TemplateForm = TemplateForm;