"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoadMappingsProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../shared_imports");
var _lib = require("../../lib");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/load_mappings/load_mappings_provider.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MAX_ERRORS_TO_DISPLAY = 1;
const getTexts = (view, totalErrors = 0) => ({
  modalTitle: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.loadJsonModalTitle', {
    defaultMessage: 'Load JSON'
  }),
  buttons: {
    confirm: view === 'json' ? _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.loadJsonModal.loadButtonLabel', {
      defaultMessage: 'Load and overwrite'
    }) : _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.loadJsonModal.acceptWarningLabel', {
      defaultMessage: 'Continue loading'
    }),
    cancel: view === 'json' ? _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.loadJsonModal.cancelButtonLabel', {
      defaultMessage: 'Cancel'
    }) : _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.loadJsonModal.goBackButtonLabel', {
      defaultMessage: 'Go back'
    })
  },
  editor: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.loadJsonModal.jsonEditorLabel', {
      defaultMessage: 'Mappings object'
    })
  },
  validationErrors: {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.loadJsonModal.validationErrorTitle",
      defaultMessage: "{totalErrors} {totalErrors, plural, one {invalid option} other {invalid options}} detected in {mappings} object",
      values: {
        totalErrors,
        // NOTE: This doesn't need internationalization because it's part of the ES API.
        mappings: /*#__PURE__*/_react.default.createElement("code", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 82,
            columnNumber: 21
          }
        }, "mappings")
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 7
      }
    }),
    description: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.loadJsonModal.validationErrorDescription', {
      defaultMessage: 'If you continue loading the object, only valid options will be accepted.'
    })
  }
});
const getErrorMessage = error => {
  switch (error.code) {
    case 'ERR_CONFIG':
      {
        return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.idxMgmt.mappingsEditor.loadJsonModal.validationError.configurationMessage",
          defaultMessage: "The {configName} configuration is invalid.",
          values: {
            configName: /*#__PURE__*/_react.default.createElement("code", {
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 103,
                columnNumber: 25
              }
            }, error.configName)
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 99,
            columnNumber: 9
          }
        });
      }
    case 'ERR_FIELD':
      {
        return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.idxMgmt.mappingsEditor.loadJsonModal.validationError.fieldMessage",
          defaultMessage: "The {fieldPath} field is invalid.",
          values: {
            fieldPath: /*#__PURE__*/_react.default.createElement("code", {
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 114,
                columnNumber: 24
              }
            }, error.fieldPath)
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 110,
            columnNumber: 9
          }
        });
      }
    case 'ERR_PARAMETER':
      {
        return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.idxMgmt.mappingsEditor.loadJsonModal.validationError.parameterMessage",
          defaultMessage: "The {paramName} parameter on field {fieldPath} is invalid.",
          values: {
            paramName: /*#__PURE__*/_react.default.createElement("code", {
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 125,
                columnNumber: 24
              }
            }, error.paramName),
            fieldPath: /*#__PURE__*/_react.default.createElement("code", {
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 126,
                columnNumber: 24
              }
            }, error.fieldPath)
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 121,
            columnNumber: 9
          }
        });
      }
  }
};
const LoadMappingsProvider = ({
  onJson,
  esNodesPlugins,
  children
}) => {
  var _state$errors, _state$json;
  const [state, setState] = (0, _react.useState)({
    isModalOpen: false
  });
  const [totalErrorsToDisplay, setTotalErrorsToDisplay] = (0, _react.useState)(MAX_ERRORS_TO_DISPLAY);
  const jsonContent = (0, _react.useRef)();
  const view = state.json !== undefined && state.errors !== undefined ? 'validationResult' : 'json';
  const i18nTexts = getTexts(view, (_state$errors = state.errors) === null || _state$errors === void 0 ? void 0 : _state$errors.length);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const onJsonUpdate = (0, _react.useCallback)(jsonUpdateData => {
    jsonContent.current = jsonUpdateData;
  }, []);
  const openModal = () => {
    setState({
      isModalOpen: true
    });
  };
  const closeModal = () => {
    setState({
      isModalOpen: false
    });
  };
  const loadJson = () => {
    if (jsonContent.current === undefined) {
      // No changes have been made in the JSON, this is probably a "reset()" for the user
      onJson({});
      closeModal();
      return;
    }
    const isValidJson = jsonContent.current.validate();
    if (isValidJson) {
      // Parse and validate the JSON to make sure it won't break the UI
      const unparsed = jsonContent.current.data.format();
      const {
        value: parsed,
        errors
      } = (0, _lib.validateMappings)(unparsed, esNodesPlugins);
      if (errors) {
        setState({
          isModalOpen: true,
          json: {
            unparsed,
            parsed
          },
          errors
        });
        return;
      }
      onJson(parsed);
      closeModal();
    }
  };
  const onConfirm = () => {
    if (view === 'json') {
      loadJson();
    } else {
      // We have some JSON and we agree on the error
      onJson(state.json.parsed);
      closeModal();
    }
  };
  const onCancel = () => {
    if (view === 'json') {
      // Cancel...
      closeModal();
    } else {
      // Go back to the JSON editor to correct the errors.
      setState({
        isModalOpen: true,
        json: state.json
      });
    }
  };
  const renderErrorsFilterButton = () => {
    const showingAllErrors = totalErrorsToDisplay > MAX_ERRORS_TO_DISPLAY;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: () => setTotalErrorsToDisplay(showingAllErrors ? MAX_ERRORS_TO_DISPLAY : state.errors.length),
      iconType: showingAllErrors ? 'arrowUp' : 'arrowDown',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 203,
        columnNumber: 7
      }
    }, showingAllErrors ? _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.hideErrorsButtonLabel', {
      defaultMessage: 'Hide errors'
    }) : _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.showAllErrorsButtonLabel', {
      defaultMessage: 'Show {numErrors} more errors',
      values: {
        numErrors: state.errors.length - MAX_ERRORS_TO_DISPLAY
      }
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children(openModal), state.isModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: i18nTexts.modalTitle,
    titleProps: {
      id: modalTitleId
    },
    onCancel: onCancel,
    onConfirm: onConfirm,
    cancelButtonText: i18nTexts.buttons.cancel,
    confirmButtonText: i18nTexts.buttons.confirm,
    maxWidth: 600,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 9
    }
  }, view === 'json' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.mappingsEditor.loadJsonModal.jsonEditorHelpText",
    defaultMessage: "Provide a mappings object, for example, the object assigned to an index {mappings} property. This will overwrite existing mappings, dynamic templates, and options.",
    values: {
      mappings: /*#__PURE__*/_react.default.createElement("code", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 245,
          columnNumber: 31
        }
      }, "mappings")
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.JsonEditor, {
    label: i18nTexts.editor.label,
    onUpdate: onJsonUpdate,
    defaultValue: (_state$json = state.json) === null || _state$json === void 0 ? void 0 : _state$json.unparsed,
    codeEditorProps: {
      height: '450px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 15
    }
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18nTexts.validationErrors.title,
    iconType: "warning",
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 19
    }
  }, i18nTexts.validationErrors.description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement("ol", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 17
    }
  }, state.errors.slice(0, totalErrorsToDisplay).map((error, i) => /*#__PURE__*/_react.default.createElement("li", {
    key: i,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 21
    }
  }, getErrorMessage(error)))), state.errors.length > MAX_ERRORS_TO_DISPLAY && renderErrorsFilterButton()))));
};
exports.LoadMappingsProvider = LoadMappingsProvider;