"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditFieldFormRow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _shared_imports = require("../../../../shared_imports");
var _lib = require("../../../../lib");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/fields/edit_field/edit_field_form_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EditFieldFormRow = exports.EditFieldFormRow = /*#__PURE__*/_react.default.memo(({
  title,
  description,
  docLink,
  defaultToggleValue,
  formFieldPath,
  children,
  withToggle = true,
  configPath,
  'data-test-subj': dataTestSubj
}) => {
  const form = (0, _shared_imports.useFormContext)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const styles = {
    formRow: (0, _react2.css)`
        margin-bottom: ${euiTheme.size.xl};

        &:last-child {
          margin-bottom: 0;
        }
      `,
    description: (0, _react2.css)`
        padding-top: ${euiTheme.size.xs};
      `
  };
  const initialVisibleState = withToggle === false ? true : defaultToggleValue !== undefined ? defaultToggleValue : formFieldPath !== undefined ? (0, _lib.getFieldConfig)(configPath ? configPath : formFieldPath).defaultValue : false;
  const [isContentVisible, setIsContentVisible] = (0, _react.useState)(initialVisibleState);
  const isChildrenFunction = typeof children === 'function';
  const onToggle = () => {
    if (isContentVisible === true) {
      /**
       * We are hiding the children (and thus removing any form field from the DOM).
       * We need to reset the form to re-enable a possible disabled "save" button (from a previous validation error).
       */
      form.reset({
        resetValues: false
      });
    }
    setIsContentVisible(!isContentVisible);
  };
  const renderToggleInput = () => formFieldPath === undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: title,
    checked: isContentVisible,
    onChange: onToggle,
    "data-test-subj": "formRowToggle",
    showLabel: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: formFieldPath,
    config: {
      ...(0, _lib.getFieldConfig)(configPath ? configPath : formFieldPath),
      defaultValue: initialVisibleState
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  }, field => {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.ToggleField, {
      field: field,
      "data-test-subj": "abc",
      euiFieldProps: {
        label: title,
        showLabel: false,
        'data-test-subj': 'formRowToggle'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 15
      }
    });
  });
  const renderContent = () => {
    const toggle = withToggle && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 36
      }
    }, renderToggleInput());
    const controlsTitle = /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 11
      }
    }, title));
    const controlsDescription = description && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued",
      css: styles.description,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 9
      }
    }, description);
    const controlsHeader = (controlsTitle || controlsDescription) && /*#__PURE__*/_react.default.createElement("div", {
      style: {
        paddingLeft: withToggle === false ? '0' : undefined
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "spaceBetween",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 13
      }
    }, controlsTitle), docLink ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: docLink.text,
      disableScreenReaderOutput: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      href: docLink.href,
      target: "_blank",
      iconType: "question",
      "aria-label": docLink.text,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 19
      }
    }))) : null), controlsDescription);
    const controls = (isContentVisible && children !== undefined || isChildrenFunction) && /*#__PURE__*/_react.default.createElement("div", {
      style: {
        paddingLeft: withToggle === false ? '0' : undefined
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 11
      }
    }), isChildrenFunction ? children(isContentVisible) : children);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      css: styles.formRow,
      "data-test-subj": dataTestSubj,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 9
      }
    }, toggle, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 193,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 13
      }
    }, controlsHeader, controls)));
  };
  return formFieldPath ? /*#__PURE__*/_react.default.createElement(_shared_imports.FormDataProvider, {
    pathsToWatch: formFieldPath,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 7
    }
  }, formData => {
    setIsContentVisible((0, _lodash.get)(formData, formFieldPath));
    return renderContent();
  }) : renderContent();
});