"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useComponentTemplatesContext = exports.useApi = exports.ComponentTemplatesProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lib = require("./lib");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/component_templates/component_templates_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ComponentTemplatesContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const ComponentTemplatesProvider = ({
  children,
  value
}) => {
  const {
    httpClient,
    apiBasePath,
    trackMetric,
    docLinks,
    toasts,
    getUrlForApp,
    executionContext,
    startServices
  } = value;
  const useRequest = (0, _lib.getUseRequest)(httpClient);
  const sendRequest = (0, _lib.getSendRequest)(httpClient);
  const api = (0, _lib.getApi)(useRequest, sendRequest, apiBasePath, trackMetric);
  const documentation = (0, _lib.getDocumentation)(docLinks);
  return /*#__PURE__*/_react.default.createElement(ComponentTemplatesContext.Provider, {
    value: {
      api,
      documentation,
      trackMetric,
      toasts,
      httpClient,
      apiBasePath,
      getUrlForApp,
      executionContext,
      startServices
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, children);
};
exports.ComponentTemplatesProvider = ComponentTemplatesProvider;
const useComponentTemplatesContext = () => {
  const ctx = (0, _react.useContext)(ComponentTemplatesContext);
  if (!ctx) {
    throw new Error('"useComponentTemplatesContext" can only be called inside of ComponentTemplatesProvider!');
  }
  return ctx;
};
exports.useComponentTemplatesContext = useComponentTemplatesContext;
const useApi = () => useComponentTemplatesContext().api;
exports.useApi = useApi;