"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmDelete = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _notification = require("../../../services/notification");
var _api_errors = require("../../../services/api_errors");
var _api = require("../../../services/api");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/policy_list/components/confirm_delete.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class ConfirmDelete extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isDeleteConfirmed: false
    });
    (0, _defineProperty2.default)(this, "setIsDeleteConfirmed", confirmed => {
      this.setState({
        isDeleteConfirmed: confirmed
      });
    });
    (0, _defineProperty2.default)(this, "deletePolicy", async () => {
      const {
        policyToDelete,
        callback
      } = this.props;
      const policyName = policyToDelete.name;
      try {
        await (0, _api.deletePolicy)(policyName);
        const message = _i18n.i18n.translate('xpack.indexLifecycleMgmt.confirmDelete.successMessage', {
          defaultMessage: 'Deleted policy {policyName}',
          values: {
            policyName
          }
        });
        _notification.toasts.addSuccess(message);
      } catch (e) {
        const title = _i18n.i18n.translate('xpack.indexLifecycleMgmt.confirmDelete.errorMessage', {
          defaultMessage: 'Error deleting policy {policyName}',
          values: {
            policyName
          }
        });
        (0, _api_errors.showApiError)(e, title);
      }
      if (callback) {
        callback();
      }
    });
    (0, _defineProperty2.default)(this, "isPolicyPolicy", true);
  }
  render() {
    var _policyToDelete$polic, _policyToDelete$polic2;
    const {
      policyToDelete,
      onCancel
    } = this.props;
    const {
      isDeleteConfirmed
    } = this.state;
    const isManagedPolicy = (_policyToDelete$polic = policyToDelete.policy) === null || _policyToDelete$polic === void 0 ? void 0 : (_policyToDelete$polic2 = _policyToDelete$polic._meta) === null || _policyToDelete$polic2 === void 0 ? void 0 : _policyToDelete$polic2.managed;
    const title = _i18n.i18n.translate('xpack.indexLifecycleMgmt.confirmDelete.title', {
      defaultMessage: 'Delete policy "{name}"',
      values: {
        name: policyToDelete.name
      }
    });
    const modalTitleId = (0, _eui.htmlIdGenerator)()('confirmModalTitle');
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      "data-test-subj": "deletePolicyModal",
      title: title,
      "aria-labelledby": modalTitleId,
      titleProps: {
        id: modalTitleId
      },
      onCancel: onCancel,
      onConfirm: this.deletePolicy,
      cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.confirmDelete.cancelButton",
        defaultMessage: "Cancel",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 76,
          columnNumber: 11
        }
      }),
      confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.confirmDelete.deleteButton",
        defaultMessage: "Delete",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 11
        }
      }),
      buttonColor: "danger",
      confirmButtonDisabled: isManagedPolicy ? !isDeleteConfirmed : false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 7
      }
    }, isManagedPolicy ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.deletePolicyModal.proceedWithCautionCallOutTitle",
        defaultMessage: "Deleting a managed policy can break Kibana",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 15
        }
      }),
      color: "danger",
      iconType: "warning",
      "data-test-subj": "deleteManagedPolicyCallOut",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.deletePolicyModal.proceedWithCautionCallOutDescription",
      defaultMessage: "Managed policies are critical for internal operations. If you delete this managed policy, you can\u2019t recover it.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
      id: "confirmDeletePolicyCheckbox",
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.deletePolicyModal.confirmDeleteCheckboxLabel",
        defaultMessage: "I understand the consequences of deleting a managed policy",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 112,
          columnNumber: 17
        }
      }),
      checked: isDeleteConfirmed,
      onChange: e => this.setIsDeleteConfirmed(e.target.checked),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 13
      }
    })) : /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.confirmDelete.undoneWarning",
      defaultMessage: "You can't recover a deleted policy.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 13
      }
    })));
  }
}
exports.ConfirmDelete = ConfirmDelete;