"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getImageEditor = void 0;
var _react = _interopRequireDefault(require("react"));
var _sharedUxFileContext = require("@kbn/shared-ux-file-context");
var _imports = require("../../imports");
var _kibana_services = require("../../services/kibana_services");
var _validate_url = require("../../utils/validate_url");
var _image_viewer_context = require("../image_viewer/image_viewer_context");
var _image_editor_flyout = require("./image_editor_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/image_embeddable/public/components/image_editor/get_image_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const getImageEditor = async ({
  initialImageConfig,
  onSave,
  closeFlyout,
  ariaLabelledBy
}) => {
  const filesClient = _kibana_services.filesService.filesClientFactory.asUnscoped();
  const user = await _kibana_services.coreServices.security.authc.getCurrentUser();
  return /*#__PURE__*/_react.default.createElement(_sharedUxFileContext.FilesContext, {
    client: filesClient,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_image_viewer_context.ImageViewerContext.Provider, {
    value: {
      getImageDownloadHref: fileId => {
        return filesClient.getDownloadHref({
          id: fileId,
          fileKind: _imports.imageEmbeddableFileKind.id
        });
      },
      validateUrl: (0, _validate_url.createValidateUrl)(_kibana_services.coreServices.http.externalUrl)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_image_editor_flyout.ImageEditorFlyout, {
    user: user,
    onSave: imageConfig => {
      onSave === null || onSave === void 0 ? void 0 : onSave(imageConfig);
      closeFlyout();
    },
    onCancel: closeFlyout,
    initialImageConfig: initialImageConfig,
    ariaLabelledBy: ariaLabelledBy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 9
    }
  })));
};
exports.getImageEditor = getImageEditor;