"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteComponentTemplates = void 0;
var _pMap = _interopRequireDefault(require("p-map"));
var _errors = require("../../../../errors");
var _constants = require("../../../../constants");
var _ = require("../../..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteComponentTemplates = async (esClient, componentTemplateIds) => {
  const logger = _.appContextService.getLogger();
  if (componentTemplateIds.length) {
    logger.info(`Deleting currently installed component template ids ${componentTemplateIds}`);
  }
  await (0, _pMap.default)(componentTemplateIds, async componentTemplateId => {
    await deleteComponentTemplate(esClient, componentTemplateId);
    logger.info(`Deleted: ${componentTemplateId}`);
  }, {
    concurrency: _constants.MAX_CONCURRENT_COMPONENT_TEMPLATES
  });
};
exports.deleteComponentTemplates = deleteComponentTemplates;
async function deleteComponentTemplate(esClient, name) {
  // '*' shouldn't ever appear here, but it still would delete all templates
  if (name && name !== '*' && !name.endsWith(_constants.USER_SETTINGS_TEMPLATE_SUFFIX)) {
    try {
      await esClient.cluster.deleteComponentTemplate({
        name
      }, {
        ignore: [404]
      });
    } catch (error) {
      throw new _errors.FleetError(`Error deleting component template ${name}: ${error.message}`);
    }
  }
}