"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RootPrivilegesCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/components/enrollment_instructions/root_privileges_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RootPrivilegesCallout = ({
  rootIntegrations = []
}) => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return rootIntegrations.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "warning",
    title: _i18n.i18n.translate('xpack.fleet.agentEnrollmentCallout.rootPrivilegesTitle', {
      defaultMessage: 'Root privileges required'
    }),
    "data-test-subj": "rootPrivilegesCallout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollmentCallout.rootPrivilegesMessage",
    defaultMessage: "This agent policy contains the following integrations that require Elastic Agents to have root privileges. To ensure that all data required by the integrations can be collected, enroll the agents using an account with root privileges. For more information, see the {guideLink}",
    values: {
      guideLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.unprivilegedMode,
        target: "_blank",
        external: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 35,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentEnrollmentCallout.rootPrivilegesMessage.guideLink",
        defaultMessage: "Fleet and Elastic Agent Guide",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 36,
          columnNumber: 17
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  }, rootIntegrations.map(item => /*#__PURE__*/_react.default.createElement("li", {
    key: item.name,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 13
    }
  }, item.title)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  })) : null;
};
exports.RootPrivilegesCallout = RootPrivilegesCallout;