"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContextMenuActions = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/components/context_menu_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ContextMenuActions = exports.ContextMenuActions = /*#__PURE__*/_react.default.memo(({
  button,
  onChange,
  isOpen,
  ...props
}) => {
  const [isOpenState, setIsOpenState] = (0, _react.useState)(false);
  const handleCloseMenu = (0, _react.useCallback)(() => {
    if (onChange) {
      onChange(false);
    } else {
      setIsOpenState(false);
    }
  }, [setIsOpenState, onChange]);
  const handleToggleMenu = (0, _react.useCallback)(() => {
    if (onChange) {
      onChange(!isOpen);
    } else {
      setIsOpenState(!isOpenState);
    }
  }, [isOpenState, onChange, isOpen]);
  const actionButton = button ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, button.props, {
    onClick: handleToggleMenu,
    isDisabled: props.isManaged,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }), button.children) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    isDisabled: props.isManaged,
    iconType: "boxesHorizontal",
    onClick: handleToggleMenu,
    "aria-label": _i18n.i18n.translate('xpack.fleet.genericActionsMenuText', {
      defaultMessage: 'Open'
    }),
    "data-test-subj": "agentActionsBtn",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downRight",
    panelPaddingSize: "none",
    button: props.isManaged ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      title: _i18n.i18n.translate('xpack.fleet.externallyManagedLabel', {
        defaultMessage: 'This is externally managed integration policy.'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 11
      }
    }, actionButton) : actionButton,
    isOpen: isOpen === undefined ? isOpenState : isOpen,
    closePopover: handleCloseMenu,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  }, 'items' in props ? /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: props.items,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    panels: props.panels,
    initialPanelId: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  }));
});