"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ALL_INSTALLED_CATEGORY = exports.ALL_CATEGORY = void 0;
exports.CategoryFacets = CategoryFacets;
exports.UPDATE_FAILED_CATEGORY = exports.UPDATE_FAILED = exports.UPDATES_AVAILABLE_CATEGORY = exports.UPDATES_AVAILABLE = exports.INSTALL_FAILED_CATEGORY = exports.INSTALL_FAILED = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _components = require("../../../../components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/home/category_facets.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const UPDATES_AVAILABLE = exports.UPDATES_AVAILABLE = 'updates_available';
const INSTALL_FAILED = exports.INSTALL_FAILED = 'install_failed';
const UPDATE_FAILED = exports.UPDATE_FAILED = 'update_failed';
const ALL_CATEGORY = exports.ALL_CATEGORY = {
  id: '',
  title: _i18n.i18n.translate('xpack.fleet.epmList.allPackagesFilterLinkText', {
    defaultMessage: 'All categories'
  })
};
const ALL_INSTALLED_CATEGORY = exports.ALL_INSTALLED_CATEGORY = {
  id: '',
  title: _i18n.i18n.translate('xpack.fleet.epmList.allPackagesInstalledFilterLinkText', {
    defaultMessage: 'All installed'
  })
};
const UPDATES_AVAILABLE_CATEGORY = exports.UPDATES_AVAILABLE_CATEGORY = {
  id: UPDATES_AVAILABLE,
  title: _i18n.i18n.translate('xpack.fleet.epmList.updatesAvailableFilterLinkText', {
    defaultMessage: 'Updates available'
  })
};
const INSTALL_FAILED_CATEGORY = exports.INSTALL_FAILED_CATEGORY = {
  id: INSTALL_FAILED,
  title: _i18n.i18n.translate('xpack.fleet.epmList.installFailedFilterLinkText', {
    defaultMessage: 'Install failed'
  })
};
const UPDATE_FAILED_CATEGORY = exports.UPDATE_FAILED_CATEGORY = {
  id: UPDATE_FAILED,
  title: _i18n.i18n.translate('xpack.fleet.epmList.updateFailedFilterLinkText', {
    defaultMessage: 'Update failed'
  })
};
function CategoryFacets({
  isLoading,
  categories,
  selectedCategory,
  onCategoryChange
}) {
  const controls = /*#__PURE__*/_react.default.createElement(_eui.EuiFacetGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 5
    }
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_components.Loading, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  })) : categories.map(category => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFacetButton, {
      "data-test-subj": `epmList.categories.${category.id}`,
      isSelected: category.id === selectedCategory,
      key: category.id,
      id: category.id,
      quantity: category.count,
      onClick: () => onCategoryChange(category),
      "aria-label": _i18n.i18n.translate('xpack.fleet.epmList.facetButton.ariaLabel', {
        defaultMessage: '{key}, {count} {count, plural, one { integration } other { integrations }}',
        values: {
          key: category.title,
          count: category.count
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 13
      }
    }, category.title);
  }));
  return controls;
}