"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CompressedInstallationStatus = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/components/compressed_installation_status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CompressedInstallationStatus = ({
  installStatus,
  isActive,
  installedTooltip,
  installFailedTooltip,
  styles
}) => {
  const cardPanelClassNames = (0, _classnames.default)({
    [styles.compressedInstallationStatus]: true,
    [styles.compressedInstalledStatus]: !isActive,
    [styles.compressedActiveStatus]: isActive
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    className: cardPanelClassNames,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, isActive ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    "data-test-subj": "compressed-active-icon",
    type: "checkInCircleFilled",
    className: styles.compressedActiveStatusIcon,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    "data-test-subj": "compressed-installed-tooltip",
    position: "bottom",
    content: installStatus === 'installed' ? installedTooltip : installFailedTooltip,
    anchorClassName: styles.compressedInstalledStatusIcon,
    type: "warningFilled",
    iconProps: {
      'data-test-subj': 'compressed-installed-icon'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  }));
};
exports.CompressedInstallationStatus = CompressedInstallationStatus;