"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OutputFormRemoteEsSection = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _multi_row_input = require("../multi_row_input");
var _services = require("../../../../services");
var _hooks = require("../../../../hooks");
var _output_form_secret_form_row = require("./output_form_secret_form_row");
var _ssl_form_section = require("./ssl_form_section");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/settings/components/edit_output_flyout/output_form_remote_es.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OutputFormRemoteEsSection = props => {
  const {
    docLinks,
    cloud
  } = (0, _hooks.useStartServices)();
  const {
    inputs,
    useSecretsStorage,
    onToggleSecretStorage
  } = props;
  const [isConvertedToSecret, setIsConvertedToSecret] = _react.default.useState({
    serviceToken: false,
    kibanaAPIKey: false,
    sslKey: false
  });
  const {
    enableSyncIntegrationsOnRemote,
    enableSSLSecrets
  } = _services.ExperimentalFeaturesService.get();
  const enableSyncIntegrations = enableSyncIntegrationsOnRemote && _hooks.licenseService.isEnterprise() && !(cloud !== null && cloud !== void 0 && cloud.isServerlessEnabled);
  const [isRemoteClusterInstructionsOpen, setIsRemoteClusterInstructionsOpen] = _react.default.useState(false);
  const [isFirstLoad, setIsFirstLoad] = _react.default.useState(true);
  (0, _react.useEffect)(() => {
    if (!isFirstLoad) return;
    setIsFirstLoad(false);
    // populate the secret input with the value of the plain input in order to re-save the output with secret storage
    if (useSecretsStorage) {
      let isServiceTokenSecret = false;
      if (inputs.serviceTokenInput.value && !inputs.serviceTokenSecretInput.value) {
        inputs.serviceTokenSecretInput.setValue(inputs.serviceTokenInput.value);
        inputs.serviceTokenInput.clear();
        isServiceTokenSecret = true;
      }
      let isSslKeySecretInput = false;
      if (enableSSLSecrets) {
        if (inputs.sslKeyInput.value && !inputs.sslKeySecretInput.value) {
          inputs.sslKeySecretInput.setValue(inputs.sslKeyInput.value);
          inputs.sslKeyInput.clear();
          isSslKeySecretInput = true;
        }
      }
      setIsConvertedToSecret({
        ...isConvertedToSecret,
        serviceToken: isServiceTokenSecret,
        sslKey: isSslKeySecretInput
      });
    }
  }, [useSecretsStorage, inputs.serviceTokenInput, inputs.serviceTokenSecretInput, inputs.kibanaAPIKeyInput, isFirstLoad, setIsFirstLoad, isConvertedToSecret, inputs.sslKeyInput, inputs.sslKeySecretInput, enableSSLSecrets]);
  const onToggleSecretAndClearValue = secretEnabled => {
    if (secretEnabled) {
      inputs.serviceTokenInput.clear();
      inputs.kibanaAPIKeyInput.clear();
      if (enableSSLSecrets) inputs.sslKeyInput.clear();
    } else {
      inputs.serviceTokenSecretInput.setValue('');
      if (enableSSLSecrets) inputs.sslKeyInput.setValue('');
    }
    setIsConvertedToSecret({
      ...isConvertedToSecret,
      serviceToken: false,
      kibanaAPIKey: false,
      sslKey: false
    });
    onToggleSecretStorage(secretEnabled);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_multi_row_input.MultiRowInput, (0, _extends2.default)({
    "data-test-subj": "settingsOutputsFlyout.hostUrlInput",
    label: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.remoteEsHostsInputLabel', {
      defaultMessage: 'Hosts'
    }),
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.remoteEsHostsInputPlaceholder', {
      defaultMessage: 'Specify host URL'
    })
  }, inputs.elasticsearchUrlInput.props, {
    isUrl: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 7
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 7
    }
  }), !useSecretsStorage ? /*#__PURE__*/_react.default.createElement(_output_form_secret_form_row.SecretFormRow, (0, _extends2.default)({
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.serviceTokenLabel",
      defaultMessage: "Service token",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 13
      }
    })
  }, inputs.serviceTokenInput.formRowProps, {
    useSecretsStorage: useSecretsStorage,
    onToggleSecretStorage: onToggleSecretAndClearValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
    fullWidth: true,
    "data-test-subj": "serviceTokenSecretInput"
  }, inputs.serviceTokenInput.props, {
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.remoteESHostPlaceholder', {
      defaultMessage: 'Specify service token'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 11
    }
  }))) : /*#__PURE__*/_react.default.createElement(_output_form_secret_form_row.SecretFormRow, (0, _extends2.default)({
    fullWidth: true,
    title: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.serviceTokenLabel', {
      defaultMessage: 'Service token'
    })
  }, inputs.serviceTokenSecretInput.formRowProps, {
    cancelEdit: inputs.serviceTokenSecretInput.cancelEdit,
    useSecretsStorage: useSecretsStorage,
    isConvertedToSecret: isConvertedToSecret.serviceToken,
    onToggleSecretStorage: onToggleSecretAndClearValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
    "data-test-subj": "serviceTokenSecretInput",
    fullWidth: true
  }, inputs.serviceTokenSecretInput.props, {
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.remoteESHostPlaceholder', {
      defaultMessage: 'Specify service token'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.serviceTokenCalloutText",
      defaultMessage: "Generate a service token by running this API request in the remote Kibana Console and copy the response value",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 11
      }
    }),
    "data-test-subj": "serviceTokenCallout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 9
    }
  }, `POST kbn:/api/fleet/service_tokens
{
  "remote": true
}`)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_ssl_form_section.SSLFormSection, {
    type: inputs.typeInput.value,
    inputs: inputs,
    useSecretsStorage: enableSSLSecrets && useSecretsStorage,
    isConvertedToSecret: isConvertedToSecret.sslKey,
    onToggleSecretAndClearValue: onToggleSecretAndClearValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 7
    }
  }), enableSyncIntegrations ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.syncIntegrationsFormRowLabel",
      defaultMessage: "If enabled, integration assets will be installed on the remote Elasticsearch cluster",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 219,
        columnNumber: 15
      }
    })
  }, inputs.syncIntegrationsInput.formRowProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, (0, _extends2.default)({}, inputs.syncIntegrationsInput.props, {
    "data-test-subj": "syncIntegrationsSwitch",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.syncIntegrationsSwitchLabel",
      defaultMessage: "Synchronize integrations",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 230,
        columnNumber: 17
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 13
    }
  }))), inputs.syncIntegrationsInput.value === true && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.syncUninstalledIntegrationsFormRowLabel",
      defaultMessage: "If enabled, uninstalled integrations will also be uninstalled on the remote Elasticsearch cluster",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 243,
        columnNumber: 19
      }
    })
  }, inputs.syncUninstalledIntegrationsInput.formRowProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, (0, _extends2.default)({}, inputs.syncUninstalledIntegrationsInput.props, {
    "data-test-subj": "syncUninstalledIntegrationsSwitch",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.syncUninstalledIntegrationsSwitchLabel",
      defaultMessage: "Uninstall integrations on remote",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 254,
        columnNumber: 21
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "info",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.remoteClusterConfigurationCalloutTitle",
      defaultMessage: "Additional remote cluster configuration required",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 265,
        columnNumber: 19
      }
    }),
    "data-test-subj": "remoteClusterConfigurationCallout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 15
    }
  }, isRemoteClusterInstructionsOpen ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => setIsRemoteClusterInstructionsOpen(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.remoteClusterConfiguration.collapseInstructionsButtonLabel",
    defaultMessage: "Collapse steps",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 21
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => setIsRemoteClusterInstructionsOpen(true),
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.remoteClusterConfiguration.viewInstructionButtonLabel",
    defaultMessage: "View steps",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 21
    }
  })), isRemoteClusterInstructionsOpen && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.remoteClusterConfiguration.description",
    defaultMessage: "To sync integrations from this cluster, the remote Elasticsearch output needs additional configuration. {documentationLink}.",
    values: {
      documentationLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        href: docLinks.links.fleet.remoteESOoutput,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 295,
          columnNumber: 27
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.settings.remoteClusterConfiguration.documentationLink",
        defaultMessage: "Learn more",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 296,
          columnNumber: 29
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement("ol", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.remoteClusterConfiguration.addRemoteClusterStep",
    defaultMessage: "In the remote cluster, open Kibana and go to {appPath}, and follow the steps to add this cluster.",
    values: {
      appPath: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 312,
          columnNumber: 31
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.settings.remoteClusterConfiguration.addRemoteClusterKibanaPath",
        defaultMessage: "Stack Management > Remote Clusters",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 313,
          columnNumber: 33
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 25
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 321,
      columnNumber: 25
    }
  })), /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 323,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.remoteClusterConfiguration.replicationStep",
    defaultMessage: "Go to {appPath} and create a follower index using the cluster from Step 1. The leader index is {leaderIndex} from this cluster and should be replicated to the follower index {followerIndex} on the remote cluster.",
    values: {
      appPath: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 329,
          columnNumber: 31
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.settings.remoteClusterConfiguration.replicationKibanaPath",
        defaultMessage: "Stack Management > Cross-Cluster Replication",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 330,
          columnNumber: 33
        }
      })),
      leaderIndex: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 336,
          columnNumber: 42
        }
      }, "fleet-synced-integrations"),
      followerIndex: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 338,
          columnNumber: 31
        }
      }, "fleet-synced-integrations-ccr-", (0, _lodash.snakeCase)(inputs.nameInput.props.value) || '<output name>')
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 25
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 345,
      columnNumber: 25
    }
  })), /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 347,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.remoteClusterConfiguration.configureKibanaStep",
    defaultMessage: "Below, provide the access details for the remote cluster's Kibana instance.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 348,
      columnNumber: 25
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 354,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.remoteClusterConfiguration.ccsDescription",
    defaultMessage: "To search accross remote clusters from this cluster, see the {prerequisites}. Once the remote cluster is added, CCS Data Views will be created automatically.",
    values: {
      prerequisites: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: `${docLinks.links.ccs.guide}#_prerequisites`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 360,
          columnNumber: 27
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.settings.remoteClusterConfiguration.ccsDocumentationLink",
        defaultMessage: "CCS prerequisites",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 364,
          columnNumber: 29
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 355,
      columnNumber: 21
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 375,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.kibanaURLInputLabel",
      defaultMessage: "Remote Kibana URL",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 379,
        columnNumber: 19
      }
    })
  }, inputs.kibanaURLInput.formRowProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 376,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
    "data-test-subj": "settingsOutputsFlyout.kibanaURLInput",
    fullWidth: true
  }, inputs.kibanaURLInput.props, {
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.kibanaURLInputPlaceholder', {
      defaultMessage: 'Specify Kibana URL'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 386,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 398,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.kibanaAPIKeyLabel",
      defaultMessage: "Remote Kibana API Key",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 403,
        columnNumber: 19
      }
    })
  }, inputs.kibanaAPIKeyInput.formRowProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 400,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldPassword, (0, _extends2.default)({
    fullWidth: true,
    type: "dual",
    "data-test-subj": "kibanaAPIKeySecretInput"
  }, inputs.kibanaAPIKeyInput.props, {
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.kibanaAPIKeyPlaceholder', {
      defaultMessage: 'Specify encoded Kibana API Key'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 410,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 424,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.kibanaAPIKeyCalloutText",
      defaultMessage: "Create an API Key by running this API request in the remote Kibana Console and copy the encoded value",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 427,
        columnNumber: 19
      }
    }),
    "data-test-subj": "kibanaAPIKeyCallout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 425,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 434,
      columnNumber: 17
    }
  }, ` POST /_security/api_key
   {
     "name": "integration_sync_api_key",
     "role_descriptors": {
       "integration_writer": {
         "cluster": [],
        "indices":[],
        "applications": [{
           "application": "kibana-.kibana",
             "privileges": ["feature_fleet.read", "feature_fleetv2.read"],
             "resources": ["*"]
         }]
        }
     }
   }`)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 452,
      columnNumber: 15
    }
  }))) : null);
};
exports.OutputFormRemoteEsSection = OutputFormRemoteEsSection;