"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentStatusFilter = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_dismissable_tour = require("../../../../../../hooks/use_dismissable_tour");
var _hooks = require("../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_list_page/components/agent_status_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const statusFilters = [{
  status: 'healthy',
  label: _i18n.i18n.translate('xpack.fleet.agentList.statusHealthyFilterText', {
    defaultMessage: 'Healthy'
  })
}, {
  status: 'unhealthy',
  label: _i18n.i18n.translate('xpack.fleet.agentList.statusUnhealthyFilterText', {
    defaultMessage: 'Unhealthy'
  })
}, {
  status: 'orphaned',
  label: _i18n.i18n.translate('xpack.fleet.agentList.statusOrphanedFilterText', {
    defaultMessage: 'Orphaned'
  })
}, {
  status: 'updating',
  label: _i18n.i18n.translate('xpack.fleet.agentList.statusUpdatingFilterText', {
    defaultMessage: 'Updating'
  })
}, {
  status: 'offline',
  label: _i18n.i18n.translate('xpack.fleet.agentList.statusOfflineFilterText', {
    defaultMessage: 'Offline'
  })
}, {
  status: 'inactive',
  label: _i18n.i18n.translate('xpack.fleet.agentList.statusInactiveFilterText', {
    defaultMessage: 'Inactive'
  })
}, {
  status: 'unenrolled',
  label: _i18n.i18n.translate('xpack.fleet.agentList.statusUnenrolledFilterText', {
    defaultMessage: 'Unenrolled'
  })
}, {
  status: 'uninstalled',
  label: _i18n.i18n.translate('xpack.fleet.agentList.statusUninstalledFilterText', {
    defaultMessage: 'Uninstalled'
  })
}];
const LeftpaddedNotificationBadge = (0, _styledComponents.default)(_eui.EuiNotificationBadge)`
  margin-left: 10px;
`;
const InactiveAgentsTourStep = ({
  children,
  isOpen,
  onDismiss
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
  content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.inactiveAgentsTourStepContent",
    defaultMessage: "Some agents have become inactive and have been hidden. Use status filters to show inactive or unenrolled agents.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  })),
  isStepOpen: isOpen,
  minWidth: 300,
  step: 1,
  stepsTotal: 0,
  title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.inactiveAgentsTourStepTitle",
    defaultMessage: "Inactive agents",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }),
  onFinish: onDismiss,
  anchorPosition: "upCenter",
  maxWidth: 280,
  footerAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onDismiss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.genericTourPopover.dismissButton",
    defaultMessage: "Got it",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 9
    }
  })),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 88,
    columnNumber: 3
  }
}, children);
const AgentStatusFilter = props => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    selectedStatus,
    onSelectedStatusChange,
    disabled,
    totalInactiveAgents,
    isOpenByDefault = false
  } = props;
  const [lastSeenInactiveAgentsCount, setLastSeenInactiveAgentsCount] = (0, _hooks.useLastSeenInactiveAgentsCount)();
  const {
    isHidden: inactiveAgentsCalloutHasBeenDismissed,
    isOpen: isInactiveAgentsTourOpen,
    dismiss: dismissInactiveAgentsCallout
  } = (0, _use_dismissable_tour.useDismissableTour)('INACTIVE_AGENTS');
  const newlyInactiveAgentsCount = (0, _react.useMemo)(() => {
    const newVal = totalInactiveAgents - lastSeenInactiveAgentsCount;
    if (newVal < 0) {
      return 0;
    }
    return newVal;
  }, [lastSeenInactiveAgentsCount, totalInactiveAgents]);
  (0, _react.useMemo)(() => {
    if (selectedStatus.length && selectedStatus.includes('inactive') && newlyInactiveAgentsCount) {
      setLastSeenInactiveAgentsCount(totalInactiveAgents);
    }
  }, [selectedStatus, newlyInactiveAgentsCount, setLastSeenInactiveAgentsCount, totalInactiveAgents]);
  (0, _react.useMemo)(() => {
    // reduce the number of last seen inactive agents count to the total inactive agents count
    // e.g if agents have become healthy again
    if (totalInactiveAgents > 0 && lastSeenInactiveAgentsCount > totalInactiveAgents) {
      setLastSeenInactiveAgentsCount(totalInactiveAgents);
    }
  }, [lastSeenInactiveAgentsCount, totalInactiveAgents, setLastSeenInactiveAgentsCount]);

  // Status for filtering
  const [isStatusFilterOpen, setIsStatusFilterOpen] = (0, _react.useState)(isOpenByDefault);
  const updateIsStatusFilterOpen = isOpen => {
    if (isOpen && newlyInactiveAgentsCount > 0 && !inactiveAgentsCalloutHasBeenDismissed) {
      dismissInactiveAgentsCallout();
    }
    setIsStatusFilterOpen(isOpen);
  };
  const getOptions = (0, _react.useCallback)(() => {
    return statusFilters.map(({
      label,
      status
    }) => {
      return {
        label,
        checked: selectedStatus.includes(status) ? 'on' : undefined,
        key: status,
        append: status === 'inactive' && newlyInactiveAgentsCount > 0 ? /*#__PURE__*/_react.default.createElement(LeftpaddedNotificationBadge, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 194,
            columnNumber: 13
          }
        }, newlyInactiveAgentsCount) : undefined
      };
    });
  }, [selectedStatus, newlyInactiveAgentsCount]);
  const [options, setOptions] = (0, _react.useState)(getOptions());
  (0, _react.useEffect)(() => {
    setOptions(getOptions());
  }, [getOptions]);
  const onOptionsChange = (0, _react.useCallback)(newOptions => {
    setOptions(newOptions);
    newOptions.forEach((option, index) => {
      if (option.checked !== options[index].checked) {
        const status = option.key;
        if (option.checked !== 'on') {
          onSelectedStatusChange([...selectedStatus.filter(s => s !== status)]);
        } else {
          onSelectedStatusChange([...selectedStatus, status]);
        }
        return;
      }
    });
  }, [onSelectedStatusChange, options, selectedStatus]);
  return /*#__PURE__*/_react.default.createElement(InactiveAgentsTourStep, {
    isOpen: newlyInactiveAgentsCount > 0 && isInactiveAgentsTourOpen,
    onDismiss: dismissInactiveAgentsCallout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    zIndex: Number(euiTheme.levels.header) - 1,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      iconType: "arrowDown",
      onClick: () => updateIsStatusFilterOpen(!isStatusFilterOpen),
      isSelected: isStatusFilterOpen,
      hasActiveFilters: selectedStatus.length > 0,
      numActiveFilters: selectedStatus.length,
      numFilters: statusFilters.length,
      disabled: disabled,
      "data-test-subj": "agentList.statusFilter",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 233,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.statusFilterText",
      defaultMessage: "Status",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 243,
        columnNumber: 13
      }
    })),
    isOpen: isStatusFilterOpen,
    closePopover: () => updateIsStatusFilterOpen(false),
    panelPaddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    options: options,
    onChange: onOptionsChange,
    "data-test-subj": "agentList.agentStatusFilterOptions",
    listProps: {
      paddingSize: 's',
      style: {
        minWidth: 140
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 9
    }
  }, list => list)));
};
exports.AgentStatusFilter = AgentStatusFilter;