"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectLogLevel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _gte = _interopRequireDefault(require("semver/functions/gte"));
var _hooks = require("../../../../../hooks");
var _constants = require("../../../../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_details_page/components/agent_logs/select_log_level.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SelectLogLevel = exports.SelectLogLevel = /*#__PURE__*/(0, _react.memo)(({
  agent,
  agentPolicyLogLevel = _constants.DEFAULT_LOG_LEVEL
}) => {
  var _agent$local_metadata, _agent$local_metadata2, _agent$local_metadata3, _agent$local_metadata4, _agent$local_metadata5, _agent$local_metadata6, _agent$local_metadata7;
  const authz = (0, _hooks.useAuthz)();
  const {
    notifications,
    docLinks
  } = (0, _hooks.useStartServices)();
  const [isSetLevelLoading, setIsSetLevelLoading] = (0, _react.useState)(false);
  const [isResetLevelLoading, setIsResetLevelLoading] = (0, _react.useState)(false);
  const canResetLogLevel = (0, _gte.default)((_agent$local_metadata = agent.local_metadata) === null || _agent$local_metadata === void 0 ? void 0 : (_agent$local_metadata2 = _agent$local_metadata.elastic) === null || _agent$local_metadata2 === void 0 ? void 0 : (_agent$local_metadata3 = _agent$local_metadata2.agent) === null || _agent$local_metadata3 === void 0 ? void 0 : _agent$local_metadata3.version, '8.15.0', true);
  const [agentLogLevel, setAgentLogLevel] = (0, _react.useState)((_agent$local_metadata4 = (_agent$local_metadata5 = agent.local_metadata) === null || _agent$local_metadata5 === void 0 ? void 0 : (_agent$local_metadata6 = _agent$local_metadata5.elastic) === null || _agent$local_metadata6 === void 0 ? void 0 : (_agent$local_metadata7 = _agent$local_metadata6.agent) === null || _agent$local_metadata7 === void 0 ? void 0 : _agent$local_metadata7.log_level) !== null && _agent$local_metadata4 !== void 0 ? _agent$local_metadata4 : _constants.DEFAULT_LOG_LEVEL);
  const [selectedLogLevel, setSelectedLogLevel] = (0, _react.useState)(agentLogLevel);
  const resetLogLevel = (0, _react.useCallback)(() => {
    setIsResetLevelLoading(true);
    async function send() {
      try {
        const res = await (0, _hooks.sendPostAgentAction)(agent.id, {
          action: {
            type: 'SETTINGS',
            data: {
              log_level: null
            }
          }
        });
        if (res.error) {
          throw res.error;
        }

        // TODO: reset to an empty state?
        setAgentLogLevel(agentPolicyLogLevel);
        setSelectedLogLevel(agentPolicyLogLevel);
        notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.fleet.agentLogs.resetLogLevel.successText', {
          defaultMessage: `Reset agent logging level to policy`
        }));
      } catch (error) {
        notifications.toasts.addError(error, {
          title: _i18n.i18n.translate('xpack.fleet.agentLogs.resetLogLevel.errorTitleText', {
            defaultMessage: 'Error resetting agent logging level'
          })
        });
      }
      setIsResetLevelLoading(false);
    }
    send();
  }, [agent.id, agentPolicyLogLevel, notifications]);
  const onClickApply = (0, _react.useCallback)(() => {
    setIsSetLevelLoading(true);
    async function send() {
      try {
        const res = await (0, _hooks.sendPostAgentAction)(agent.id, {
          action: {
            type: 'SETTINGS',
            data: {
              log_level: selectedLogLevel
            }
          }
        });
        if (res.error) {
          throw res.error;
        }
        setAgentLogLevel(selectedLogLevel);
        notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.fleet.agentLogs.selectLogLevel.successText', {
          defaultMessage: `Changed agent logging level to ''{logLevel}''`,
          values: {
            logLevel: selectedLogLevel
          }
        }));
      } catch (error) {
        notifications.toasts.addError(error, {
          title: _i18n.i18n.translate('xpack.fleet.agentLogs.selectLogLevel.errorTitleText', {
            defaultMessage: 'Error updating agent logging level'
          })
        });
      }
      setIsSetLevelLoading(false);
    }
    send();
  }, [notifications, selectedLogLevel, agent.id]);
  (0, _react.useEffect)(() => {
    if (selectedLogLevel !== agentLogLevel) {
      onClickApply();
    }
  }, [selectedLogLevel, agentLogLevel, onClickApply]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentLogs.selectLogLevelLabelText",
    defaultMessage: "Agent logging level",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentLogs.selectLogLevelLabelText",
    defaultMessage: "Sets the log level for the agent. The default log level is {infoText}. {guideLink}",
    values: {
      infoText: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 145,
          columnNumber: 29
        }
      }, "info"),
      guideLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        external: true,
        href: docLinks.links.fleet.agentLevelLogging,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 147,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentLogs.levelGuideLinkText",
        defaultMessage: "Learn More",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 152,
          columnNumber: 23
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    disabled: isSetLevelLoading || !authz.fleet.allAgents,
    compressed: true,
    fullWidth: true,
    id: "selectAgentLogLevel",
    "data-test-subj": "selectAgentLogLevel",
    value: selectedLogLevel,
    onChange: event => {
      setSelectedLogLevel(event.target.value);
    },
    options: _constants.AGENT_LOG_LEVELS.map(level => ({
      value: level,
      text: level
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 13
    }
  })), canResetLogLevel && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "both",
    size: "xs",
    disabled: !authz.fleet.allAgents,
    isLoading: isSetLevelLoading || isResetLevelLoading,
    iconType: "cross",
    onClick: resetLogLevel,
    "data-test-subj": "resetLogLevelBtn",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentLogs.resetLogLevelLabelText",
    defaultMessage: "Reset to policy",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 17
    }
  })))));
});