"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentPolicyGeneralFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/components/agent_policy_general_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AgentPolicyGeneralFields = ({
  agentPolicy,
  updateAgentPolicy,
  validation,
  nameLabel,
  disabled
}) => {
  const [touchedFields, setTouchedFields] = (0, _react.useState)({});
  const isDisabled = disabled || agentPolicy.is_managed === true;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    key: "name",
    label: nameLabel || /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.nameFieldLabel",
      defaultMessage: "Name",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 11
      }
    }),
    isDisabled: isDisabled,
    error: touchedFields.name && validation.name ? validation.name : null,
    isInvalid: Boolean(touchedFields.name && validation.name),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "createAgentPolicyNameField",
    disabled: isDisabled,
    fullWidth: true,
    value: agentPolicy.name,
    onChange: e => updateAgentPolicy({
      name: e.target.value
    }),
    isInvalid: Boolean(touchedFields.name && validation.name),
    onBlur: () => setTouchedFields({
      ...touchedFields,
      name: true
    }),
    placeholder: _i18n.i18n.translate('xpack.fleet.agentPolicyForm.nameFieldPlaceholder', {
      defaultMessage: 'Choose a name'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }));
};
exports.AgentPolicyGeneralFields = AgentPolicyGeneralFields;