"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizationNoResults = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/charts-plugin/public");
var _utils = require("../utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/chart_expressions/expression_partition_vis/public/components/visualization_noresults.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const VisualizationNoResults = ({
  hasNegativeValues = false,
  chartType,
  renderComplete
}) => {
  if (hasNegativeValues) {
    const message = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "expressionPartitionVis.negativeValuesFound",
      defaultMessage: "{chartType} chart can't render with negative values.",
      values: {
        chartType: `${chartType[0].toUpperCase()}${chartType.slice(1)}`
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 7
      }
    });
    return /*#__PURE__*/_react.default.createElement(_public.EmptyPlaceholder, {
      dataTestSubj: "partitionVisNegativeValues",
      icon: "warning",
      iconColor: "warning",
      message: message,
      renderComplete: renderComplete,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_public.EmptyPlaceholder, {
    dataTestSubj: "partitionVisEmptyValues",
    icon: (0, _utils.getIcon)(chartType),
    renderComplete: renderComplete,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  });
};
exports.VisualizationNoResults = VisualizationNoResults;