"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SMALL_MULTIPLES_ID = exports.ChartSplit = void 0;
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/chart_expressions/expression_partition_vis/public/components/chart_split.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const CHART_SPLIT_ID = '__pie_chart_split__';
const SMALL_MULTIPLES_ID = exports.SMALL_MULTIPLES_ID = '__pie_chart_sm__';
const ChartSplit = ({
  splitColumnAccessor,
  splitRowAccessor
}) => {
  if (!splitColumnAccessor && !splitRowAccessor) return null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_charts.GroupBy, {
    id: CHART_SPLIT_ID,
    by: (spec, datum) => {
      const splitTypeAccessor = splitColumnAccessor || splitRowAccessor;
      if (splitTypeAccessor) {
        return typeof splitTypeAccessor === 'function' ? splitTypeAccessor(datum) : datum[splitTypeAccessor];
      }
      return spec.id;
    },
    sort: _charts.Predicate.DataIndex,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.SmallMultiples, {
    id: SMALL_MULTIPLES_ID,
    splitVertically: splitRowAccessor ? CHART_SPLIT_ID : undefined,
    splitHorizontally: splitColumnAccessor ? CHART_SPLIT_ID : undefined,
    style: {
      verticalPanelPadding: {
        outer: 0.1,
        inner: 0.1
      },
      horizontalPanelPadding: {
        outer: 0.1,
        inner: 0.1
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }));
};
exports.ChartSplit = ChartSplit;