"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "DataTypes", {
  enumerable: true,
  get: function () {
    return _labels.DataTypes;
  }
});
exports.ExploratoryViewPage = ExploratoryViewPage;
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/kibana-utils-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _last_updated = require("./header/last_updated");
var _exploratory_view = require("./exploratory_view");
var _use_kibana = require("./hooks/use_kibana");
var _use_app_data_view = require("./hooks/use_app_data_view");
var _use_series_storage = require("./hooks/use_series_storage");
var _refresh_button = require("./header/refresh_button");
var _labels = require("./labels");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PAGE_TITLE = _i18n.i18n.translate('xpack.exploratoryView.expView.heading.label', {
  defaultMessage: 'Explore data'
});
function ExploratoryViewPage({
  app,
  saveAttributes,
  useSessionStorage = false
}) {
  const {
    services: {
      uiSettings,
      notifications,
      observabilityShared
    }
  } = (0, _use_kibana.useKibana)();
  const history = (0, _reactRouterDom.useHistory)();
  const ObservabilityPageTemplate = observabilityShared.navigation.PageTemplate;
  (0, _public2.useTrackPageview)({
    app: 'observability-overview',
    path: 'exploratory-view'
  });
  (0, _public2.useTrackPageview)({
    app: 'observability-overview',
    path: 'exploratory-view',
    delay: 15000
  });
  (0, _public2.useBreadcrumbs)([{
    text: _i18n.i18n.translate('xpack.exploratoryView.overview', {
      defaultMessage: 'Explore data'
    })
  }], {
    app,
    classicOnly: true
  });
  const kbnUrlStateStorage = useSessionStorage ? (0, _public.createSessionStorageStateStorage)() : (0, _public.createKbnUrlStateStorage)({
    history,
    useHash: uiSettings.get('state:storeInSessionStorage'),
    ...(0, _public.withNotifyOnErrors)(notifications.toasts)
  });
  return /*#__PURE__*/_react.default.createElement(_use_series_storage.UrlStorageContextProvider, {
    storage: kbnUrlStateStorage,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    pageHeader: {
      pageTitle: PAGE_TITLE,
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_refresh_button.RefreshButton, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 80,
          columnNumber: 28
        }
      }), /*#__PURE__*/_react.default.createElement(_last_updated.LastUpdated, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 80,
          columnNumber: 47
        }
      })]
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_use_app_data_view.DataViewContextProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_exploratory_view.ExploratoryView, {
    saveAttributes: saveAttributes,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  }))));
}

// eslint-disable-next-line import/no-default-export
var _default = exports.default = ExploratoryViewPage;