"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.URLSearch = URLSearch;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _selectable_url_list = require("./selectable_url_list");
var _use_url_search = require("./use_url_search");
var _use_series_filters = require("../../hooks/use_series_filters");
var _elasticsearch_fieldnames = require("../../configurations/constants/elasticsearch_fieldnames");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/components/url_search/url_search.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const processSelectedItems = items => {
  const urlItems = items.filter(({
    isWildcard
  }) => !isWildcard);
  const wildcardItems = items.filter(({
    isWildcard
  }) => isWildcard);
  const includedItems = (0, _lodash.map)(urlItems.filter(option => option.checked === 'on'), 'label');
  const excludedItems = (0, _lodash.map)(urlItems.filter(option => option.checked === 'off'), 'label');

  // for wild cards we use title since label contains extra information
  const includedWildcards = (0, _lodash.map)(wildcardItems.filter(option => option.checked === 'on'), 'title');

  // for wild cards we use title since label contains extra information
  const excludedWildcards = (0, _lodash.map)(wildcardItems.filter(option => option.checked === 'off'), 'title');
  return {
    includedItems,
    excludedItems,
    includedWildcards,
    excludedWildcards
  };
};
const getWildcardLabel = wildcard => {
  return _i18n.i18n.translate('xpack.exploratoryView.urlFilter.wildcard', {
    defaultMessage: 'Use wildcard *{wildcard}*',
    values: {
      wildcard
    }
  });
};
function URLSearch({
  series,
  seriesConfig,
  seriesId
}) {
  const [popoverIsOpen, setPopoverIsOpen] = (0, _react.useState)(false);
  const [query, setQuery] = (0, _react.useState)('');
  const [items, setItems] = (0, _react.useState)([]);
  const {
    values,
    loading
  } = (0, _use_url_search.useUrlSearch)({
    query,
    series,
    seriesConfig,
    seriesId
  });
  (0, _react.useEffect)(() => {
    var _series$filters;
    const queryLabel = getWildcardLabel(query);
    const currFilter = ((_series$filters = series.filters) !== null && _series$filters !== void 0 ? _series$filters : []).find(({
      field
    }) => field === _elasticsearch_fieldnames.TRANSACTION_URL);
    const {
      wildcards = [],
      notWildcards = [],
      values: currValues = [],
      notValues: currNotValues = []
    } = currFilter !== null && currFilter !== void 0 ? currFilter : {
      field: _elasticsearch_fieldnames.TRANSACTION_URL
    };
    setItems(prevItems => {
      const {
        includedItems,
        excludedItems
      } = processSelectedItems(prevItems);
      const newItems = (values !== null && values !== void 0 ? values : []).map(item => {
        if (includedItems.includes(item.label) || wildcards.includes(item.label) || currValues.includes(item.label)) {
          return {
            ...item,
            checked: 'on',
            title: item.label
          };
        }
        if (excludedItems.includes(item.label) || notWildcards.includes(item.label) || currNotValues.includes(item.label)) {
          return {
            ...item,
            checked: 'off',
            title: item.label,
            ...item
          };
        }
        return {
          ...item,
          title: item.label,
          checked: undefined
        };
      });
      wildcards.forEach(wildcard => {
        newItems.unshift({
          title: wildcard,
          label: getWildcardLabel(wildcard),
          isWildcard: true,
          checked: 'on'
        });
      });
      notWildcards.forEach(wildcard => {
        newItems.unshift({
          title: wildcard,
          label: getWildcardLabel(wildcard),
          isWildcard: true,
          checked: 'off'
        });
      });
      let queryItem = prevItems.find(({
        isNewWildcard
      }) => isNewWildcard);
      if (query) {
        if (!queryItem) {
          queryItem = {
            title: query,
            label: queryLabel,
            isNewWildcard: true,
            isWildcard: true
          };
          newItems.unshift(queryItem);
        }
        return [{
          ...queryItem,
          label: queryLabel,
          title: query
        }, ...newItems];
      }
      return newItems;
    });
    // we don't want to add series in the dependency, for that we have an extra side effect below
    // eslint-disable-next-line  react-hooks/exhaustive-deps
  }, [values, loading, query]);
  (0, _react.useEffect)(() => {
    var _series$filters2;
    const currFilter = ((_series$filters2 = series.filters) !== null && _series$filters2 !== void 0 ? _series$filters2 : []).find(({
      field
    }) => field === _elasticsearch_fieldnames.TRANSACTION_URL);
    const {
      wildcards = [],
      notWildcards = [],
      values: currValues = [],
      notValues: currNotValues = []
    } = currFilter !== null && currFilter !== void 0 ? currFilter : {
      field: _elasticsearch_fieldnames.TRANSACTION_URL
    };
    setItems(prevItems => {
      const newItems = (prevItems !== null && prevItems !== void 0 ? prevItems : []).map(item => {
        if (currValues.includes(item.label) || wildcards.includes(item.title)) {
          return {
            ...item,
            checked: 'on'
          };
        }
        if (currNotValues.includes(item.label) || notWildcards.includes(item.title)) {
          return {
            ...item,
            checked: 'off'
          };
        }
        return {
          ...item,
          checked: undefined
        };
      });
      return newItems;
    });
  }, [series]);
  const onSelectionChange = updatedOptions => {
    setItems(updatedOptions);
  };
  const {
    replaceFilter
  } = (0, _use_series_filters.useSeriesFilters)({
    seriesId,
    series
  });
  const onSelectionApply = () => {
    const {
      includedItems,
      excludedItems,
      includedWildcards,
      excludedWildcards
    } = processSelectedItems(items);
    replaceFilter({
      field: _elasticsearch_fieldnames.TRANSACTION_URL,
      values: includedItems,
      notValues: excludedItems,
      wildcards: includedWildcards,
      notWildcards: excludedWildcards
    });
    setQuery('');
    setPopoverIsOpen(false);
  };
  const hasChanged = () => {
    var _series$filters3;
    const {
      includedItems,
      excludedItems,
      includedWildcards,
      excludedWildcards
    } = processSelectedItems(items);
    const currFilter = ((_series$filters3 = series.filters) !== null && _series$filters3 !== void 0 ? _series$filters3 : []).find(({
      field
    }) => field === _elasticsearch_fieldnames.TRANSACTION_URL);
    const {
      wildcards = [],
      notWildcards = [],
      values: currValues = [],
      notValues: currNotValues = []
    } = currFilter !== null && currFilter !== void 0 ? currFilter : {
      field: _elasticsearch_fieldnames.TRANSACTION_URL
    };
    return !(0, _lodash.isEqual)(includedItems.sort(), currValues.sort()) || !(0, _lodash.isEqual)(excludedItems.sort(), currNotValues.sort()) || !(0, _lodash.isEqual)(wildcards.sort(), includedWildcards.sort()) || !(0, _lodash.isEqual)(notWildcards.sort(), excludedWildcards.sort());
  };
  return /*#__PURE__*/_react.default.createElement(_selectable_url_list.SelectableUrlList, {
    loading: Boolean(loading),
    onInputChange: val => setQuery(val),
    data: {
      items,
      total: items.length
    },
    onSelectionChange: onSelectionChange,
    searchValue: query,
    popoverIsOpen: popoverIsOpen,
    setPopoverIsOpen: setPopoverIsOpen,
    onSelectionApply: onSelectionApply,
    hasChanged: hasChanged,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 5
    }
  });
}