"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatePicker = DatePicker;
exports.default = void 0;
var _eui = require("@elastic/eui");
var _public = require("@kbn/data-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _public2 = require("@kbn/kibana-react-plugin/public");
var _use_date_picker_context = require("../../../hooks/use_date_picker_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/date_picker/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function DatePicker({
  rangeFrom,
  rangeTo,
  refreshPaused,
  refreshInterval,
  width = 'restricted',
  onTimeRangeRefresh
}) {
  const {
    updateTimeRange,
    updateRefreshInterval
  } = (0, _use_date_picker_context.useDatePickerContext)();
  const timePickerQuickRanges = (0, _public2.useUiSetting)(_public.UI_SETTINGS.TIMEPICKER_QUICK_RANGES);
  const commonlyUsedRanges = timePickerQuickRanges.map(({
    from,
    to,
    display
  }) => ({
    start: from,
    end: to,
    label: display
  }));
  function onRefreshChange({
    isPaused,
    refreshInterval: interval
  }) {
    updateRefreshInterval({
      isPaused,
      interval
    });
  }
  const onRefresh = (0, _react.useCallback)(newRange => {
    if (onTimeRangeRefresh) {
      onTimeRangeRefresh(newRange);
    }
    updateTimeRange(newRange);
  }, [onTimeRangeRefresh, updateTimeRange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    start: rangeFrom,
    end: rangeTo,
    onTimeChange: onRefresh,
    onRefresh: onRefresh,
    isPaused: refreshPaused,
    refreshInterval: refreshInterval,
    onRefreshChange: onRefreshChange,
    commonlyUsedRanges: commonlyUsedRanges,
    width: width,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  });
}

// eslint-disable-next-line import/no-default-export
var _default = exports.default = DatePicker;