"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sortCommand = void 0;
var _i18n = require("@kbn/i18n");
var _autocomplete = require("./autocomplete");
var _validate = require("./validate");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const sortCommandMethods = {
  autocomplete: _autocomplete.autocomplete,
  validate: _validate.validate
};
const sortCommand = exports.sortCommand = {
  name: 'sort',
  methods: sortCommandMethods,
  metadata: {
    description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.sortDoc', {
      defaultMessage: 'Sorts all results by the specified fields. By default, null values are treated as being larger than any other value. With an ascending sort order, null values are sorted last, and with a descending sort order, null values are sorted first. You can change that by providing NULLS FIRST or NULLS LAST'
    }),
    declaration: 'SORT column1 [ASC/DESC][NULLS FIRST/NULLS LAST][, ..., columnN [ASC/DESC][NULLS FIRST/NULLS LAST]]',
    examples: ['… | SORT a DESC, b NULLS LAST, c ASC NULLS FIRST', '… | SORT b NULLS LAST', '… | SORT c ASC NULLS FIRST', '… | SORT a - abs(b)']
  }
};