"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManageCustomPipelineActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _uiTheme = require("@kbn/ui-theme");
var _pipelines_logic = require("../pipelines_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/search_index/pipelines/ingest_pipelines/manage_custom_pipeline_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const revertContextMenuItemCSS = (0, _react2.css)`
  color: ${_uiTheme.euiThemeVars.euiColorDanger};
`;
const ManageCustomPipelineActions = ({
  buttonRef
}) => {
  const [isMenuOpen, setIsMenuOpen] = (0, _react.useState)(false);
  const {
    openDeleteModal
  } = (0, _kea.useActions)(_pipelines_logic.PipelinesLogic);
  const onButtonClick = () => setIsMenuOpen(!isMenuOpen);
  const onRevertClick = () => {
    openDeleteModal();
    setIsMenuOpen(false);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      buttonRef: buttonRef,
      size: "s",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: onButtonClick,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.ingestionPipeline.manageButton', {
      defaultMessage: 'Manage'
    })),
    isOpen: isMenuOpen,
    closePopover: () => setIsMenuOpen(false),
    panelPaddingSize: "none",
    anchorPosition: "downRight",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      onClick: onRevertClick,
      icon: "trash",
      css: revertContextMenuItemCSS,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.ingestionPipeline.revertPipelineAction', {
      defaultMessage: 'Revert to default configuration'
    }))],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }));
};
exports.ManageCustomPipelineActions = ManageCustomPipelineActions;