"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultPipelineItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _indices = require("../../../../utils/indices");
var _curl_request = require("../../components/curl_request/curl_request");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/search_index/pipelines/ingest_pipelines/default_pipeline_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DefaultPipelineItem = ({
  index,
  indexName,
  ingestionMethod,
  openPipelineSettings,
  pipelineName,
  pipelineState
}) => {
  /**
   * If we don't open the accordion on load, the curl code never shows the copy button
   * Because if the accordion is closed, the code block is not present in the DOM
   * And EuiCodeBlock doesn't show the copy button if it's virtualized (ie not present in DOM)
   * It doesn't re-evaluate whether it's present in DOM if the inner text doesn't change
   * Opening and closing makes sure it's present in DOM on initial load, so the copy button shows
   * We use setImmediate to then close it on the next javascript loop
   */
  const [accordionOpen, setAccordionOpen] = (0, _react.useState)(true);
  (0, _react.useEffect)(() => {
    setImmediate(() => setAccordionOpen(false));
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 15
    }
  }, pipelineName))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-ingestPipelines-settings`,
    onClick: openPipelineSettings,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.ingestPipelinesCard.settings.label', {
    defaultMessage: 'Settings'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  }, (0, _indices.isApiIndex)(index) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-ingestPipelines-viewCurlRequest`,
    buttonContent: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.ingestPipelinesCard.accordion.label', {
      defaultMessage: 'Ingest a document using cURL'
    }),
    id: "ingestPipelinesCurlAccordion",
    forceState: accordionOpen ? 'open' : 'closed',
    onClick: () => setAccordionOpen(!accordionOpen),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_curl_request.CurlRequest, {
    document: {
      body: 'body',
      title: 'Title'
    },
    indexName: indexName,
    pipeline: {
      ...pipelineState,
      name: pipelineName
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    iconType: "lock",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.ingestPipelinesCard.managedBadge.label', {
    defaultMessage: 'Managed'
  })))))));
};
exports.DefaultPipelineItem = DefaultPipelineItem;