"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChooseConnector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../shared/constants");
var _kibana = require("../../../../../shared/kibana");
var _new_connector_logic = require("../../../new_index/method_connector/new_connector_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/connectors/create_connector/components/choose_connector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ChooseConnector = ({
  selfManaged,
  disabled
}) => {
  var _selectedConnector$ic;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [selectedOption, setSelectedOption] = (0, _react.useState)([]);
  const renderOption = (option, searchValue, contentClassName) => {
    const {
      _append,
      key,
      label,
      _prepend
    } = option;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      className: contentClassName,
      key: key + '-span',
      gutterSize: "m",
      responsive: false,
      direction: "row",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 9
      }
    }, _prepend), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      css: (0, _react2.css)`
            overflow: auto;
          `,
      grow: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      textAlign: "left",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextTruncate, {
      text: label,
      truncation: "end",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
      gutterSize: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 11
      }
    }, _append)));
  };
  const [selectableOptions, selectableSetOptions] = (0, _react.useState)([]);
  const {
    connectorTypes
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const allConnectors = (0, _react.useMemo)(() => connectorTypes.sort((a, b) => a.name.localeCompare(b.name)), [connectorTypes]);
  const {
    selectedConnector
  } = (0, _kea.useValues)(_new_connector_logic.NewConnectorLogic);
  const {
    setSelectedConnector
  } = (0, _kea.useActions)(_new_connector_logic.NewConnectorLogic);
  const getInitialOptions = () => {
    return allConnectors.map((connector, key) => {
      const _append = [];
      let _ariaLabelAppend = '';
      if (connector.isTechPreview) {
        _append.push(/*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          "aria-label": _constants.TECH_PREVIEW_LABEL,
          key: key + '-preview',
          iconType: "beaker",
          color: "hollow",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 104,
            columnNumber: 11
          }
        }, _constants.TECH_PREVIEW_LABEL));
        _ariaLabelAppend += `, ${_constants.TECH_PREVIEW_LABEL}`;
      }
      if (connector.isBeta) {
        _append.push(/*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          "aria-label": _constants.BETA_LABEL,
          key: key + '-beta',
          iconType: 'beta',
          color: "hollow",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 117,
            columnNumber: 11
          }
        }, _constants.BETA_LABEL));
        _ariaLabelAppend += `, ${_constants.BETA_LABEL}`;
      }
      if (selfManaged === 'native' && !connector.isNative) {
        _append.push(/*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          key: key + '-self',
          iconType: 'warning',
          color: "warning",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 125,
            columnNumber: 11
          }
        }, _constants.CONNECTOR_CLIENT_LABEL));
      }
      return {
        _append,
        _prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          size: "l",
          type: connector.iconPath,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 132,
            columnNumber: 19
          }
        }),
        'aria-label': connector.name + _ariaLabelAppend,
        key: key.toString(),
        label: connector.name
      };
    });
  };
  const initialOptions = getInitialOptions();
  (0, _react.useEffect)(() => {
    selectableSetOptions(initialOptions);
  }, [selfManaged]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isDisabled: disabled,
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.chooseConnectorSelectable.euiComboBox.accessibleScreenReaderLabelLabel', {
      defaultMessage: 'Select a data source for your connector to use.'
    }),
    prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: (_selectedConnector$ic = selectedConnector === null || selectedConnector === void 0 ? void 0 : selectedConnector.iconPath) !== null && _selectedConnector$ic !== void 0 ? _selectedConnector$ic : 'plugs',
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 16
      }
    }),
    singleSelection: true,
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.chooseConnectorSelectable.placeholder.text', {
      defaultMessage: 'Choose a data source'
    }),
    options: selectableOptions,
    selectedOptions: selectedOption,
    onChange: selectedItem => {
      setSelectedOption(selectedItem);
      if (selectedItem.length === 0) {
        setSelectedConnector(null);
        return;
      }
      const keySelected = Number(selectedItem[0].key);
      setSelectedConnector(allConnectors[keySelected]);
    },
    renderOption: renderOption,
    rowHeight: euiTheme.base / 2 * 5,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 5
    }
  });
};
exports.ChooseConnector = ChooseConnector;