"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorDetailRouter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _routes = require("../../routes");
var _index_name_logic = require("../search_index/index_name_logic");
var _index_view_logic = require("../search_index/index_view_logic");
var _connector_detail = require("./connector_detail");
var _connector_view_logic = require("./connector_view_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/connector_detail/connector_detail_router.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConnectorDetailRouter = () => {
  (0, _react.useEffect)(() => {
    const unmountName = _index_name_logic.IndexNameLogic.mount();
    const unmountView = _connector_view_logic.ConnectorViewLogic.mount();
    const unmountIndexView = _index_view_logic.IndexViewLogic.mount();
    return () => {
      unmountName();
      unmountView();
      unmountIndexView();
    };
  }, []);
  const {
    setIndexName
  } = (0, _kea.useActions)(_index_name_logic.IndexNameLogic);
  const {
    connector
  } = (0, _kea.useValues)(_connector_view_logic.ConnectorViewLogic);
  const {
    startFetchIndexPoll,
    stopFetchIndexPoll,
    resetFetchIndexApi
  } = (0, _kea.useActions)(_index_view_logic.IndexViewLogic);
  const indexName = (connector === null || connector === void 0 ? void 0 : connector.index_name) || '';
  (0, _react.useEffect)(() => {
    setIndexName(indexName);
    if (indexName) {
      startFetchIndexPoll(indexName);
    } else {
      stopFetchIndexPoll();
      resetFetchIndexApi();
    }
  }, [indexName]);
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.CONNECTOR_DETAIL_PATH,
    exact: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_connector_detail.ConnectorDetail, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.CONNECTOR_DETAIL_TAB_PATH,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_connector_detail.ConnectorDetail, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  })));
};
exports.ConnectorDetailRouter = ConnectorDetailRouter;