"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorConfiguration = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _searchConnectors = require("@kbn/search-connectors");
var _api = require("../../../../../common/types/api");
var _doc_links = require("../../../shared/doc_links");
var _http = require("../../../shared/http");
var _kibana = require("../../../shared/kibana");
var _licensing = require("../../../shared/licensing");
var _connector_helpers = require("../../utils/connector_helpers");
var _connector_filtering_logic = require("../search_index/connector/sync_rules/connector_filtering_logic");
var _index_view_logic = require("../search_index/index_view_logic");
var _attach_index_box = require("./attach_index_box");
var _advanced_config_override_callout = require("./components/advanced_config_override_callout");
var _configuration_skeleton = require("./components/configuration_skeleton");
var _example_config_callout = require("./components/example_config_callout");
var _whats_next_box = require("./components/whats_next_box");
var _connector_view_logic = require("./connector_view_logic");
var _deployment = require("./deployment");
var _native_connector_configuration = require("./native_connector_configuration");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/connector_detail/connector_configuration.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConnectorConfiguration = () => {
  var _nativeConnector$name;
  const {
    connector,
    updateConnectorConfigurationStatus
  } = (0, _kea.useValues)(_connector_view_logic.ConnectorViewLogic);
  const {
    connectorTypes: connectors
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    isSyncing,
    isWaitingForSync
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    hasPlatinumLicense
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  const {
    http
  } = (0, _kea.useValues)(_http.HttpLogic);
  const {
    advancedSnippet
  } = (0, _kea.useValues)(_connector_filtering_logic.ConnectorFilteringLogic);
  const NATIVE_CONNECTORS = (0, _react.useMemo)(() => connectors.filter(({
    isNative
  }) => isNative), [connectors]);

  // TODO service_type === "" is considered unknown/custom connector multiple places replace all of them with a better solution
  const CUSTOM_CONNECTOR = (0, _react.useMemo)(() => connectors.filter(({
    serviceType
  }) => serviceType === ''), [connectors]);
  const {
    updateConnectorConfiguration
  } = (0, _kea.useActions)(_connector_view_logic.ConnectorViewLogic);
  if (!connector) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  if (connector.is_native && connector.service_type) {
    return /*#__PURE__*/_react.default.createElement(_native_connector_configuration.NativeConnectorConfiguration, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 12
      }
    });
  }
  const isWaitingForConnector = !connector.status || connector.status === _searchConnectors.ConnectorStatus.CREATED;
  const nativeConnector = NATIVE_CONNECTORS.find(connectorDefinition => connectorDefinition.serviceType === connector.service_type) || CUSTOM_CONNECTOR[0];
  const iconPath = nativeConnector.iconPath;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null,
  // TODO remove this callout when example status is removed
  (0, _connector_helpers.isExampleConnector)(connector) && /*#__PURE__*/_react.default.createElement(_example_config_callout.ExampleConfigCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 42
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "row",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  }, iconPath && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "xl",
    type: iconPath,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 17
    }
  }, (_nativeConnector$name = nativeConnector === null || nativeConnector === void 0 ? void 0 : nativeConnector.name) !== null && _nativeConnector$name !== void 0 ? _nativeConnector$name : connector.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 15
    }
  }, connector.is_native ? _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.badgeType.nativeConnector', {
    defaultMessage: 'Elastic managed connector'
  }) : _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.badgeType.connectorClient', {
    defaultMessage: 'Self-managed connector'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_attach_index_box.AttachIndexBox, {
    connector: connector,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 11
    }
  }), connector.index_name && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_deployment.ConnectorDeployment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.configuration.title', {
    defaultMessage: 'Configuration'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonLoading, {
    isLoading: isWaitingForConnector,
    loadingContent: /*#__PURE__*/_react.default.createElement(_configuration_skeleton.ConfigurationSkeleton, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 35
      }
    }),
    loadedContent: /*#__PURE__*/_react.default.createElement(_searchConnectors.ConnectorConfigurationComponent, {
      connector: connector,
      hasPlatinumLicense: hasPlatinumLicense,
      isLoading: updateConnectorConfigurationStatus === _api.Status.LOADING,
      saveConfig: configuration => updateConnectorConfiguration({
        configuration,
        connectorId: connector.id
      }),
      subscriptionLink: _doc_links.docLinks.licenseManagement,
      stackManagementLink: http.basePath.prepend('/app/management/stack/license_management'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 23
      }
    }), (0, _connector_helpers.hasNonEmptyAdvancedSnippet)(connector, advancedSnippet) && /*#__PURE__*/_react.default.createElement(_advanced_config_override_callout.AdvancedConfigOverrideCallout, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 25
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_whats_next_box.WhatsNextBox, {
    connectorId: connector.id,
    disabled: isWaitingForConnector || !connector.last_synced,
    isWaitingForConnector: isWaitingForConnector,
    connectorIndex: connector.index_name,
    connectorStatus: connector.status,
    isSyncing: Boolean(isSyncing || isWaitingForSync),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 15
    }
  })))));
};
exports.ConnectorConfiguration = ConnectorConfiguration;