"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchApplicationSchema = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _fieldTypes = require("@kbn/field-types");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactField = require("@kbn/react-field");
var _constants = require("../../../../../common/constants");
var _routes = require("../../../enterprise_search_content/routes");
var _doc_links = require("../../../shared/doc_links");
var _encode_path_params = require("../../../shared/encode_path_params");
var _kibana = require("../../../shared/kibana");
var _react_router_helpers = require("../../../shared/react_router_helpers");
var _search_application_view_logic = require("./search_application_view_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/applications/components/search_application/search_application_schema.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SchemaFieldDetails = ({
  schemaField
}) => {
  const {
    navigateToUrl
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const notInAllIndices = schemaField.indices.some(i => i.type === 'unmapped');
  const columns = [{
    field: 'name',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.schema.fieldIndices.index.columnTitle', {
      defaultMessage: 'Parent index'
    }),
    render: name => /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
      to: `${_constants.ENTERPRISE_SEARCH_DATA_PLUGIN.URL}${(0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_INDEX_TAB_PATH, {
        indexName: name,
        tabId: 'index_mappings'
      })}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 9
      }
    }, name)
  }, {
    field: 'type',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.schema.fieldIndices.type.columnTitle', {
      defaultMessage: 'Field mapped as'
    }),
    render: name => {
      if (name === 'unmapped') return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "warning",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 85,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.searchApplications.searchApplication.schema.fieldIndices.type.unmapped",
        defaultMessage: "Unmapped",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 86,
          columnNumber: 15
        }
      }));
      return name;
    }
  }, {
    actions: [{
      description: 'View index mappings',
      icon: 'eye',
      name: 'View index',
      onClick: item => {
        navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_INDEX_TAB_PATH, {
          indexName: item.name,
          tabId: 'index_mappings'
        }));
      },
      type: 'icon'
    }]
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "l",
    color: "transparent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 7
    }
  }, notInAllIndices && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    iconType: "info",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.searchApplications.searchApplication.schema.fieldIndices.notInAllIndices.title",
      defaultMessage: "This field is not mapped in every index.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.searchApplication.schema.fieldIndices.notInAllIndices.description",
    defaultMessage: "Learn more about field mapping in",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 17
    }
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _doc_links.docLinks.elasticsearchMapping,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.searchApplication.schema.fieldIndices.notInAllIndices.link",
    defaultMessage: "our documentation.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 19
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    css: {
      '& .euiTable': {
        backgroundColor: 'transparent'
      }
    },
    columns: columns,
    items: schemaField.indices,
    responsiveBreakpoint: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 9
    }
  })));
};
const SearchApplicationSchema = () => {
  const [onlyShowConflicts, setOnlyShowConflicts] = (0, _react.useState)(false);
  const {
    isLoadingSearchApplicationSchema,
    schemaFields,
    hasSchemaConflicts
  } = (0, _kea.useValues)(_search_application_view_logic.SearchApplicationViewLogic);
  const [isFilterByPopoverOpen, setIsFilterByPopoverOpen] = (0, _react.useState)(false);
  const [itemIdToExpandedRowMap, setItemIdToExpandedRowMap] = (0, _react.useState)({});
  // get all the elasticsearch Field Types
  const esFieldTypes = Object.values(_fieldTypes.ES_FIELD_TYPES).map(fieldDataTypeName => ({
    checked: undefined,
    label: fieldDataTypeName.toString()
  }));
  const [selectedEsFieldTypes, setSelectedEsFieldTypes] = (0, _react.useState)(esFieldTypes);
  const toggleOnlyShowConflicts = (0, _react.useCallback)(() => {
    setOnlyShowConflicts(!onlyShowConflicts);
    setItemIdToExpandedRowMap({});
  }, [onlyShowConflicts]);

  // update filteredDataTypes as filter by field types are selected
  const filteredDataTypes = (0, _react.useMemo)(() => {
    const selectedDataTypes = selectedEsFieldTypes.filter(option => option.checked === 'on').map(option => option.label);
    return selectedDataTypes;
  }, [selectedEsFieldTypes]);

  // return schema fields may be with conflicts
  const schemaFieldsMaybeWithConflicts = (0, _react.useMemo)(() => {
    if (onlyShowConflicts) return schemaFields.filter(field => field.type === 'conflict');
    return schemaFields;
  }, [onlyShowConflicts, schemaFields]);
  const filteredSchemaFields = (0, _react.useMemo)(() => {
    if (filteredDataTypes.length > 0) return schemaFieldsMaybeWithConflicts.filter(field => field.indices.some(i => filteredDataTypes.includes(i.type)));
    return schemaFieldsMaybeWithConflicts;
  }, [onlyShowConflicts, schemaFields, filteredDataTypes]);
  const totalConflictsHiddenByTypeFilters = onlyShowConflicts ? schemaFieldsMaybeWithConflicts.length - filteredSchemaFields.length : 0;
  const toggleDetails = schemaField => {
    const newItemIdToExpandedRowMap = {
      ...itemIdToExpandedRowMap
    };
    if (itemIdToExpandedRowMap[schemaField.name]) {
      delete newItemIdToExpandedRowMap[schemaField.name];
    } else {
      newItemIdToExpandedRowMap[schemaField.name] = /*#__PURE__*/_react.default.createElement(SchemaFieldDetails, {
        schemaField: schemaField,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 210,
          columnNumber: 9
        }
      });
    }
    setItemIdToExpandedRowMap(newItemIdToExpandedRowMap);
  };
  const columns = [{
    render: ({
      type
    }) => {
      if (type !== 'conflict') return null;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "error",
        color: "danger",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 221,
          columnNumber: 16
        }
      });
    },
    width: '24px'
  }, {
    name: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.schema.field_name.columnTitle', {
      defaultMessage: 'Field name'
    }),
    render: ({
      name,
      type
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 233,
        columnNumber: 9
      }
    }, name.includes('.') && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "sortRight",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 234,
        columnNumber: 34
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: type === 'conflict' ? 'danger' : 'primary',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 235,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 236,
        columnNumber: 13
      }
    }, name)))
  }, {
    name: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.schema.field_type.columnTitle', {
      defaultMessage: 'Field type'
    }),
    render: ({
      type
    }) => {
      if (type === 'conflict') {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          alignItems: "center",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 251,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "danger",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 252,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.enterpriseSearch.searchApplications.searchApplication.schema.field_type.conflict",
          defaultMessage: "Conflict",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 253,
            columnNumber: 17
          }
        })));
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 263,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, {
        type: type,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 264,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 265,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 266,
          columnNumber: 15
        }
      }, type)));
    },
    width: '180px'
  }, {
    name: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.schema.field_indices.columnTitle', {
      defaultMessage: 'In all indices?'
    }),
    render: ({
      indices
    }) => {
      const inAllIndices = indices.every(i => i.type !== 'unmapped');
      return inAllIndices ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 283,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 284,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.searchApplications.searchApplication.schema.field_indices.yes",
        defaultMessage: "Yes",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 285,
          columnNumber: 15
        }
      }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 292,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.searchApplications.searchApplication.schema.field_indices.no",
        defaultMessage: "No",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 293,
          columnNumber: 13
        }
      }));
    },
    width: '110px'
  }, {
    isExpander: true,
    render: schemaField => {
      const {
        name,
        type,
        indices
      } = schemaField;
      if (type === 'conflict' || indices.some(i => i.type === 'unmapped')) {
        const icon = itemIdToExpandedRowMap[name] ? 'arrowUp' : 'arrowDown';
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          alignItems: "center",
          justifyContent: "flexEnd",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 309,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
          size: "s",
          color: "primary",
          iconType: icon,
          iconSide: "right",
          onClick: () => {
            toggleDetails(schemaField);
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 310,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.enterpriseSearch.searchApplications.searchApplication.schema.field_indices.moreInfo",
          defaultMessage: "More info",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 319,
            columnNumber: 17
          }
        })));
      }
      return null;
    },
    width: '115px'
  }];
  const filterButton = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    iconType: "arrowDown",
    iconSide: "right",
    onClick: () => setIsFilterByPopoverOpen(!isFilterByPopoverOpen),
    numFilters: selectedEsFieldTypes.length,
    hasActiveFilters: filteredDataTypes.length > 0,
    numActiveFilters: filteredDataTypes.length,
    isSelected: isFilterByPopoverOpen,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 333,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.schema.filters', {
    defaultMessage: 'Field types'
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 353,
      columnNumber: 7
    }
  }, hasSchemaConflicts && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.schema.conflictsCallOut.title', {
      defaultMessage: 'Potential field mapping issues found'
    }),
    iconType: "error",
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 355,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 364,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.searchApplication.schema.conflictsCallOut.description",
    defaultMessage: "Schema field type conflicts can be resolved by navigating to the source index directly and updating the field type of the conflicting field(s) to match that of the other source indices.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 365,
      columnNumber: 15
    }
  })), !onlyShowConflicts && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    fill: true,
    onClick: toggleOnlyShowConflicts,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 371,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.searchApplication.schema.conflictsCallOut.button",
    defaultMessage: "View conflicts",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 372,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 380,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.schema.onlyShowConflicts', {
      defaultMessage: 'Only show conflicts'
    }),
    checked: onlyShowConflicts,
    onChange: toggleOnlyShowConflicts,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 381,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 391,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 392,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.schema.filters.label', {
    defaultMessage: 'Filter By'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 400,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: filterButton,
    isOpen: isFilterByPopoverOpen,
    closePopover: () => setIsFilterByPopoverOpen(false),
    panelPaddingSize: "none",
    anchorPosition: "downCenter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 401,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    searchable: true,
    searchProps: {
      placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.schema.filters.searchPlaceholder', {
        defaultMessage: 'Filter list '
      })
    },
    options: selectedEsFieldTypes,
    onChange: options => setSelectedEsFieldTypes(options),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 408,
      columnNumber: 17
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 422,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 423,
      columnNumber: 23
    }
  }, search), list)), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 428,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceAround",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 429,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "danger",
    iconType: "eraser",
    size: "s",
    onClick: () => setSelectedEsFieldTypes(esFieldTypes),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 430,
      columnNumber: 21
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.schema.filters.clearAll', {
    defaultMessage: 'Clear all '
  })))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: filteredSchemaFields,
    columns: columns,
    loading: isLoadingSearchApplicationSchema,
    itemId: "name",
    itemIdToExpandedRowMap: itemIdToExpandedRowMap,
    responsiveBreakpoint: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 450,
      columnNumber: 9
    }
  }), totalConflictsHiddenByTypeFilters > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.searchApplications.searchApplication.schema.filters.conflict.callout.title",
      defaultMessage: "There are {totalConflictsHiddenByTypeFilters, number} more {totalConflictsHiddenByTypeFilters, plural, one {conflict} other {conflicts}}   not displayed here",
      values: {
        totalConflictsHiddenByTypeFilters
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 462,
        columnNumber: 15
      }
    }),
    color: "danger",
    iconType: "info",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 459,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 471,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.schema.filters.conflict.callout.subTitle', {
    defaultMessage: 'In order to see all field conflicts you must clear your field filters'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    color: "danger",
    onClick: () => setSelectedEsFieldTypes(esFieldTypes),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 480,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.schema.filters.conflict.callout.clearFilters', {
    defaultMessage: 'Clear filters '
  })))));
};
exports.SearchApplicationSchema = SearchApplicationSchema;