"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnterpriseSearchAnalyticsPageTemplate = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../../common/constants");
var _deprecation_callout = require("../../../shared/deprecation_callout/deprecation_callout");
var _encode_path_params = require("../../../shared/encode_path_params");
var _kibana = require("../../../shared/kibana");
var _kibana_chrome = require("../../../shared/kibana_chrome");
var _layout = require("../../../shared/layout");
var _nav = require("../../../shared/layout/nav");
var _telemetry = require("../../../shared/telemetry");
var _routes = require("../../routes");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/analytics/components/layout/page_template.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EnterpriseSearchAnalyticsPageTemplate = ({
  children,
  analyticsName,
  pageChrome,
  pageViewTelemetry,
  ...pageTemplateProps
}) => {
  const {
    updateSideNavDefinition,
    getChromeStyle$
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const chromeStyle = (0, _useObservable.default)(getChromeStyle$(), 'classic');
  const alwaysReturnNavItems = true;
  const navItems = (0, _nav.useEnterpriseSearchAnalyticsNav)(analyticsName, analyticsName ? {
    explorer: (0, _encode_path_params.generateEncodedPath)(_routes.COLLECTION_EXPLORER_PATH, {
      name: analyticsName
    }),
    integration: (0, _encode_path_params.generateEncodedPath)(_routes.COLLECTION_INTEGRATE_PATH, {
      name: analyticsName
    }),
    overview: (0, _encode_path_params.generateEncodedPath)(_routes.COLLECTION_OVERVIEW_PATH, {
      name: analyticsName
    })
  } : undefined, alwaysReturnNavItems);
  const getSelectedCollectionItems = (0, _react.useCallback)(items => {
    if (!items) return undefined;
    const buildGroup = items.find(item => item.id === 'build');
    if (!buildGroup || !buildGroup.items) return undefined;
    const searchAppsGroup = buildGroup.items.find(item => item.id === 'analyticsCollections');
    return searchAppsGroup === null || searchAppsGroup === void 0 ? void 0 : searchAppsGroup.items;
  }, []);
  (0, _react.useEffect)(() => {
    // We update the new side nav definition with the selected collection items
    updateSideNavDefinition({
      collections: getSelectedCollectionItems(navItems)
    });
  }, [navItems, updateSideNavDefinition]);
  (0, _react.useEffect)(() => {
    return () => {
      updateSideNavDefinition({
        collections: undefined
      });
    };
  }, [updateSideNavDefinition]);
  return /*#__PURE__*/_react.default.createElement(_layout.EnterpriseSearchPageTemplateWrapper, (0, _extends2.default)({}, pageTemplateProps, {
    solutionNav: {
      items: chromeStyle === 'classic' ? navItems : undefined,
      name: _constants.SEARCH_PRODUCT_NAME
    },
    setPageChrome: pageChrome && /*#__PURE__*/_react.default.createElement(_kibana_chrome.SetAnalyticsChrome, {
      trail: pageChrome,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 36
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 5
    }
  }), pageViewTelemetry && /*#__PURE__*/_react.default.createElement(_telemetry.SendEnterpriseSearchTelemetry, {
    action: "viewed",
    metric: pageViewTelemetry,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_deprecation_callout.DeprecationCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }), children);
};
exports.EnterpriseSearchAnalyticsPageTemplate = EnterpriseSearchAnalyticsPageTemplate;