"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddAnalyticsCollectionForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _add_analytics_collection_logic = require("./add_analytics_collection_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/analytics/components/add_analytics_collections/add_analytics_collection_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AddAnalyticsCollectionForm = ({
  formId,
  collectionNameField
}) => {
  const {
    createAnalyticsCollection,
    setNameValue
  } = (0, _kea.useActions)(_add_analytics_collection_logic.AddAnalyticsCollectionLogic);
  const {
    name,
    isLoading,
    canSubmit,
    inputError
  } = (0, _kea.useValues)(_add_analytics_collection_logic.AddAnalyticsCollectionLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    id: formId,
    component: "form",
    onSubmit: e => {
      e.preventDefault();
      if (canSubmit) {
        createAnalyticsCollection();
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collectionsCreate.form.label', {
      defaultMessage: 'Collection name'
    }),
    isInvalid: !!inputError,
    error: inputError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: collectionNameField,
    fullWidth: true,
    autoFocus: true,
    value: name,
    isLoading: isLoading,
    isInvalid: !!inputError,
    onChange: e => {
      setNameValue(e.target.value);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  })));
};
exports.AddAnalyticsCollectionForm = AddAnalyticsCollectionForm;