"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContentReferenceComponentFactory = void 0;
var _react = _interopRequireDefault(require("react"));
var _knowledge_base_entry_reference = require("./knowledge_base_entry_reference");
var _security_alert_reference = require("./security_alert_reference");
var _security_alerts_page_reference = require("./security_alerts_page_reference");
var _content_reference_button = require("./content_reference_button");
var _product_documentation_reference = require("./product_documentation_reference");
var _esql_query_reference = require("./esql_query_reference");
var _href_reference = require("./href_reference");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/elastic_assistant/public/src/components/get_comments/content_reference/components/content_reference_component_factory.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/** While a message is being streamed, content references are null. When a message has finished streaming, content references are either defined or undefined */

const ContentReferenceComponentFactory = ({
  contentReferencesVisible,
  contentReferenceNode
}) => {
  if (!contentReferencesVisible) return null;
  if (contentReferenceNode.contentReferenceCount === undefined) return null;
  if (contentReferenceNode.contentReference === undefined) {
    return /*#__PURE__*/_react.default.createElement(_content_reference_button.ContentReferenceButton, {
      disabled: true,
      contentReferenceCount: contentReferenceNode.contentReferenceCount,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 7
      }
    });
  }
  switch (contentReferenceNode.contentReference.type) {
    case 'KnowledgeBaseEntry':
      {
        return /*#__PURE__*/_react.default.createElement(_knowledge_base_entry_reference.KnowledgeBaseEntryReference, {
          contentReferenceNode: contentReferenceNode,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 58,
            columnNumber: 9
          }
        });
      }
    case 'SecurityAlert':
      return /*#__PURE__*/_react.default.createElement(_security_alert_reference.SecurityAlertReference, {
        contentReferenceNode: contentReferenceNode,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 67,
          columnNumber: 9
        }
      });
    case 'SecurityAlertsPage':
      return /*#__PURE__*/_react.default.createElement(_security_alerts_page_reference.SecurityAlertsPageReference, {
        contentReferenceNode: contentReferenceNode,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 75,
          columnNumber: 9
        }
      });
    case 'ProductDocumentation':
      return /*#__PURE__*/_react.default.createElement(_product_documentation_reference.ProductDocumentationReference, {
        contentReferenceNode: contentReferenceNode,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 9
        }
      });
    case 'EsqlQuery':
      {
        return /*#__PURE__*/_react.default.createElement(_esql_query_reference.EsqlQueryReference, {
          contentReferenceNode: contentReferenceNode,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 91,
            columnNumber: 9
          }
        });
      }
    case 'Href':
      {
        return /*#__PURE__*/_react.default.createElement(_href_reference.HrefReference, {
          contentReferenceNode: contentReferenceNode,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 100,
            columnNumber: 9
          }
        });
      }
    default:
      const _exhaustiveCheck = contentReferenceNode.contentReference;
      throw new Error(`Unhandled case: ${_exhaustiveCheck}`);
  }
};
exports.ContentReferenceComponentFactory = ContentReferenceComponentFactory;