"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticAssistantPublicPlugin = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _public = require("@kbn/kibana-utils-plugin/public");
var _assistant_nav_link = require("@kbn/elastic-assistant/impl/assistant_context/assistant_nav_link");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _assistant_provider = require("./src/context/assistant_context/assistant_provider");
var _typed_kibana_context = require("./src/context/typed_kibana_context/typed_kibana_context");
var _use_licence = require("./src/hooks/licence/use_licence");
var _elastic_assistant_query_client_provider = require("./src/context/query_client_context/elastic_assistant_query_client_provider");
var _assistant_space_id_provider = require("./src/context/assistant_space_id/assistant_space_id_provider");
var _telemetry_service = require("./src/common/lib/telemetry/telemetry_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/elastic_assistant/public/plugin.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// eslint-disable-next-line @typescript-eslint/no-empty-interface

class ElasticAssistantPublicPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "storage", new _public.Storage(localStorage));
    (0, _defineProperty2.default)(this, "telemetry", new _telemetry_service.TelemetryService());
    (0, _defineProperty2.default)(this, "isServerless", void 0);
    this.isServerless = context.env.packageInfo.buildFlavor === 'serverless';
  }
  setup(coreSetup) {
    this.telemetry.setup({
      analytics: coreSetup.analytics
    });
    return {};
  }
  start(coreStart, dependencies) {
    const startServices = () => {
      const {
        ...startPlugins
      } = coreStart.security;
      _use_licence.licenseService.start(dependencies.licensing.license$);
      const telemetry = this.telemetry.start();
      const services = {
        ...coreStart,
        ...startPlugins,
        licensing: dependencies.licensing,
        triggersActionsUi: dependencies.triggersActionsUi,
        security: dependencies.security,
        telemetry,
        productDocBase: dependencies.productDocBase,
        storage: this.storage,
        discover: dependencies.discover,
        spaces: dependencies.spaces,
        elasticAssistantSharedState: dependencies.elasticAssistantSharedState,
        aiAssistantManagementSelection: dependencies.aiAssistantManagementSelection
      };
      return services;
    };
    coreStart.chrome.navControls.registerRight({
      order: 1001,
      mount: target => {
        const startService = startServices();
        return this.mountAIAssistantButton(target, coreStart, startService);
      }
    });
    return {};
  }
  mountAIAssistantButton(targetDomElement, coreStart, services) {
    const {
      openChat$,
      completeOpenChat
    } = services.aiAssistantManagementSelection;
    _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_typed_kibana_context.KibanaContextProvider, {
      services: {
        appName: 'securitySolution',
        ...services
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_reactKibanaContextTheme.KibanaThemeProvider, (0, _extends2.default)({}, coreStart, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_securitySolutionNavigation.NavigationProvider, {
      core: services,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_elastic_assistant_query_client_provider.ReactQueryClientProvider, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_assistant_space_id_provider.AssistantSpaceIdProvider, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_assistant_provider.AssistantProvider, {
      isServerless: this.isServerless,
      openChatTrigger$: openChat$,
      completeOpenChat: completeOpenChat,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
      fallback: null,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_assistant_nav_link.AssistantNavLink, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 23
      }
    }), /*#__PURE__*/_react.default.createElement(_elasticAssistant.AssistantOverlay, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 23
      }
    }))))))))), targetDomElement);
    return () => _reactDom.default.unmountComponentAtNode(targetDomElement);
  }
  stop() {
    // Cleanup when plugin is stopped
  }
}
exports.ElasticAssistantPublicPlugin = ElasticAssistantPublicPlugin;