"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverMainRoute = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/kibana-utils-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _useUnmount = _interopRequireDefault(require("react-use/lib/useUnmount"));
var _public2 = require("@kbn/kibana-react-plugin/public");
var _useLatest = _interopRequireDefault(require("react-use/lib/useLatest"));
var _i18n = require("@kbn/i18n");
var _use_discover_services = require("../../hooks/use_discover_services");
var _redux = require("./state_management/redux");
var _context_awareness = require("../../context_awareness");
var _single_tab_view = require("./components/single_tab_view");
var _use_async_function = require("./hooks/use_async_function");
var _tabs_view = require("./components/tabs_view");
var _chart = require("./components/chart");
var _use_state_managers = require("./state_management/hooks/use_state_managers");
var _use_url = require("./hooks/use_url");
var _use_alert_results_toast = require("./hooks/use_alert_results_toast");
var _breadcrumbs = require("../../utils/breadcrumbs");
var _use_unsaved_changes = require("./state_management/hooks/use_unsaved_changes");
var _discover_topnav_menu = require("./components/top_nav/discover_topnav_menu");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/application/main/discover_main_route.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const defaultCustomizationCallbacks = [];
const DiscoverMainRoute = ({
  customizationContext,
  customizationCallbacks = defaultCustomizationCallbacks,
  stateStorageContainer,
  onAppLeave
}) => {
  const services = (0, _use_discover_services.useDiscoverServices)();
  const history = (0, _reactRouterDom.useHistory)();
  const [urlStateStorage] = (0, _react.useState)(() => stateStorageContainer !== null && stateStorageContainer !== void 0 ? stateStorageContainer : (0, _public.createKbnUrlStateStorage)({
    useHash: services.uiSettings.get('state:storeInSessionStorage'),
    history,
    useHashQuery: customizationContext.displayMode !== 'embedded',
    ...(0, _public.withNotifyOnErrors)(services.core.notifications.toasts)
  }));
  const {
    internalState,
    runtimeStateManager,
    searchSessionManager
  } = (0, _use_state_managers.useStateManagers)({
    services,
    urlStateStorage,
    customizationContext
  });
  (0, _use_unsaved_changes.useUnsavedChanges)({
    internalState,
    runtimeStateManager,
    onAppLeave
  });
  return /*#__PURE__*/_react.default.createElement(_redux.InternalStateProvider, {
    store: internalState,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(DiscoverMainRouteContent, {
    customizationContext: customizationContext,
    customizationCallbacks: customizationCallbacks,
    urlStateStorage: urlStateStorage,
    internalState: internalState,
    runtimeStateManager: runtimeStateManager,
    searchSessionManager: searchSessionManager,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }));
};
exports.DiscoverMainRoute = DiscoverMainRoute;
const DiscoverMainRouteContent = props => {
  const {
    customizationContext,
    runtimeStateManager
  } = props;
  const services = (0, _use_discover_services.useDiscoverServices)();
  const {
    core,
    dataViews,
    chrome,
    data,
    discoverFeatureFlags
  } = services;
  const history = (0, _reactRouterDom.useHistory)();
  const dispatch = (0, _redux.useInternalStateDispatch)();
  const rootProfileState = (0, _context_awareness.useRootProfile)();
  const tabsEnabled = discoverFeatureFlags.getTabsEnabled();
  const {
    initializeProfileDataViews
  } = (0, _context_awareness.useDefaultAdHocDataViews)();
  const [mainRouteInitializationState, initializeMainRoute] = (0, _use_async_function.useAsyncFunction)(async loadedRootProfileState => {
    const [hasESData, hasUserDataView, defaultDataViewExists] = await Promise.all([dataViews.hasData.hasESData().catch(() => false), dataViews.hasData.hasUserDataView().catch(() => false), dataViews.defaultDataViewExists().catch(() => false), dispatch(_redux.internalStateActions.loadDataViewList()).catch(() => {}), initializeProfileDataViews(loadedRootProfileState).catch(() => {})]);
    const initializationState = {
      hasESData,
      hasUserDataView: hasUserDataView && defaultDataViewExists
    };
    dispatch(_redux.internalStateActions.setInitializationState(initializationState));
    return initializationState;
  });
  const [tabsInitializationState, initializeTabs] = (0, _use_async_function.useAsyncFunction)(async ({
    discoverSessionId,
    shouldClearAllTabs
  }) => {
    await dispatch(_redux.internalStateActions.initializeTabs({
      discoverSessionId,
      shouldClearAllTabs
    })).unwrap();
  });
  const {
    id: currentDiscoverSessionId
  } = (0, _reactRouterDom.useParams)();
  const persistedDiscoverSession = (0, _redux.useInternalStateSelector)(state => state.persistedDiscoverSession);
  const currentTabId = (0, _redux.useInternalStateSelector)(state => state.tabs.unsafeCurrentId);
  const initializeDiscoverSession = (0, _useLatest.default)(({
    nextDiscoverSessionId
  }) => {
    const persistedDiscoverSessionId = persistedDiscoverSession === null || persistedDiscoverSession === void 0 ? void 0 : persistedDiscoverSession.id;
    const isSwitchingSession = Boolean(persistedDiscoverSessionId && persistedDiscoverSessionId !== nextDiscoverSessionId);
    if (!persistedDiscoverSessionId || isSwitchingSession) {
      initializeTabs({
        discoverSessionId: nextDiscoverSessionId,
        shouldClearAllTabs: isSwitchingSession
      });
    } else {
      const currentTabRuntimeState = (0, _redux.selectTabRuntimeState)(runtimeStateManager, currentTabId);
      const currentTabStateContainer = currentTabRuntimeState.stateContainer$.getValue();
      currentTabStateContainer === null || currentTabStateContainer === void 0 ? void 0 : currentTabStateContainer.appState.updateUrlWithCurrentState();
    }
  });
  (0, _react.useEffect)(() => {
    if (!rootProfileState.rootProfileLoading) {
      initializeMainRoute(rootProfileState);
    }
  }, [initializeMainRoute, rootProfileState]);
  (0, _react.useEffect)(() => {
    initializeDiscoverSession.current({
      nextDiscoverSessionId: currentDiscoverSessionId
    });
  }, [currentDiscoverSessionId, initializeDiscoverSession]);
  (0, _useUnmount.default)(() => {
    data.search.session.clear();
    for (const tabId of Object.keys(runtimeStateManager.tabs.byId)) {
      dispatch(_redux.internalStateActions.disconnectTab({
        tabId
      }));
    }
  });
  (0, _use_url.useUrl)({
    history,
    savedSearchId: currentDiscoverSessionId,
    onNewUrl: () => {
      initializeTabs({
        shouldClearAllTabs: true
      });
    }
  });
  (0, _use_alert_results_toast.useAlertResultsToast)();
  (0, _public2.useExecutionContext)(core.executionContext, {
    type: 'application',
    page: 'app',
    id: currentDiscoverSessionId || 'new'
  });
  (0, _react.useEffect)(() => {
    if (customizationContext.displayMode === 'standalone') {
      const pageTitleSuffix = persistedDiscoverSession !== null && persistedDiscoverSession !== void 0 && persistedDiscoverSession.title ? `: ${persistedDiscoverSession.title}` : '';
      chrome.docTitle.change(`Discover${pageTitleSuffix}`);
      (0, _breadcrumbs.setBreadcrumbs)({
        titleBreadcrumbText: persistedDiscoverSession === null || persistedDiscoverSession === void 0 ? void 0 : persistedDiscoverSession.title,
        services
      });
    }
  }, [chrome.docTitle, persistedDiscoverSession === null || persistedDiscoverSession === void 0 ? void 0 : persistedDiscoverSession.title, customizationContext.displayMode, services]);
  const areTabsInitializing = (0, _redux.useInternalStateSelector)(state => state.tabs.areInitializing);
  const isLoading = rootProfileState.rootProfileLoading || mainRouteInitializationState.loading || tabsInitializationState.loading || areTabsInitializing;
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_single_tab_view.BrandedLoadingIndicator, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 229,
        columnNumber: 12
      }
    });
  }
  const error = mainRouteInitializationState.error || tabsInitializationState.error;
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_single_tab_view.InitializationError, {
      error: error,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 235,
        columnNumber: 12
      }
    });
  }
  if (!mainRouteInitializationState.value.hasESData && !mainRouteInitializationState.value.hasUserDataView) {
    return /*#__PURE__*/_react.default.createElement(_single_tab_view.NoDataPage, (0, _extends2.default)({}, mainRouteInitializationState.value, {
      onDataViewCreated: () => {
        // This is unused if there is no ES data
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 243,
        columnNumber: 7
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(rootProfileState.AppWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_chart.ChartPortalsRenderer, {
    runtimeStateManager: runtimeStateManager,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_discover_topnav_menu.DiscoverTopNavMenuProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("h1", {
    className: "euiScreenReaderOnly",
    "data-test-subj": "discoverSavedSearchTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 13
    }
  }, persistedDiscoverSession !== null && persistedDiscoverSession !== void 0 && persistedDiscoverSession.title ? _i18n.i18n.translate('discover.pageTitleWithSavedSearch', {
    defaultMessage: 'Discover - {savedSearchTitle}',
    values: {
      savedSearchTitle: persistedDiscoverSession.title
    }
  }) : _i18n.i18n.translate('discover.pageTitleWithoutSavedSearch', {
    defaultMessage: 'Discover - Session not yet saved'
  })), tabsEnabled && customizationContext.displayMode !== 'embedded' ? /*#__PURE__*/_react.default.createElement(_tabs_view.TabsView, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 15
    }
  })) : /*#__PURE__*/_react.default.createElement(_single_tab_view.SingleTabView, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 15
    }
  }))))));
};