"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KeywordContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kibana_context = require("../../../../../kibana_context");
var _top_values = require("../../../top_values");
var _document_stats = require("./document_stats");
var _expanded_row_content = require("./expanded_row_content");
var _choropleth_map = require("./choropleth_map");
var _error_message = require("./error_message");
var _use_bar_color = require("./use_bar_color");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/common/components/stats_table/components/field_data_expanded_row/keyword_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const KeywordContent = ({
  config,
  onAddFilter
}) => {
  var _config$stats, _config$stats2, _config$stats3;
  const barColor = (0, _use_bar_color.useBarColor)();
  const [suggestion, setSuggestion] = (0, _react.useState)(null);
  const {
    stats,
    fieldName
  } = config;
  const fieldFormat = 'fieldFormat' in config ? config.fieldFormat : undefined;
  const {
    services: {
      maps: mapsPlugin
    }
  } = (0, _kibana_context.useDataVisualizerKibana)();
  (0, _react.useEffect)(() => {
    if (!mapsPlugin) return;
    if (!(stats !== null && stats !== void 0 && stats.topValues)) {
      setSuggestion(null);
      return;
    }
    let ignore = false;
    mapsPlugin.suggestEMSTermJoinConfig({
      sampleValues: stats.topValues.map(value => value.key),
      sampleValuesColumnName: fieldName || ''
    }).then(nextSuggestion => {
      if (!ignore) {
        setSuggestion(nextSuggestion);
      }
    }).catch(() => {
      if (!ignore) {
        setSuggestion(null);
      }
    });
    return () => {
      ignore = true;
    };
  }, [fieldName, mapsPlugin, stats === null || stats === void 0 ? void 0 : stats.topValues]);
  return /*#__PURE__*/_react.default.createElement(_expanded_row_content.ExpandedRowContent, {
    dataTestSubj: 'dataVisualizerKeywordContent',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_document_stats.DocumentStatsTable, {
    config: config,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }), (_config$stats = config.stats) !== null && _config$stats !== void 0 && _config$stats.error && fieldName !== undefined ? /*#__PURE__*/_react.default.createElement(_error_message.ErrorMessageContent, {
    fieldName: fieldName,
    error: (_config$stats2 = config.stats) === null || _config$stats2 === void 0 ? void 0 : _config$stats2.error,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 9
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_top_values.TopValues, {
    stats: stats,
    fieldFormat: fieldFormat,
    barColor: barColor,
    onAddFilter: onAddFilter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }), (_config$stats3 = config.stats) !== null && _config$stats3 !== void 0 && _config$stats3.sampledValues && fieldName !== undefined ? /*#__PURE__*/_react.default.createElement(_top_values.TopValues, {
    stats: stats,
    fieldFormat: fieldFormat,
    barColor: barColor,
    onAddFilter: onAddFilter,
    showSampledValues: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }) : null, suggestion && stats && /*#__PURE__*/_react.default.createElement(_choropleth_map.ChoroplethMap, {
    stats: stats,
    suggestion: suggestion,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 31
    }
  }));
};
exports.KeywordContent = KeywordContent;