"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScriptField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _monaco = require("@kbn/monaco");
var _shared_imports = require("../../../shared_imports");
var _lib = require("../../../lib");
var _preview = require("../../preview");
var _form_schema = require("../form_schema");
var _state_utils = require("../../../state_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_field_editor/public/components/field_editor/form_fields/script_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const mapReturnTypeToPainlessContext = runtimeType => {
  switch (runtimeType) {
    case 'keyword':
      return 'string_script_field_script_field';
    case 'long':
      return 'long_script_field_script_field';
    case 'double':
      return 'double_script_field_script_field';
    case 'date':
      return 'date_script_field';
    case 'ip':
      return 'ip_script_field_script_field';
    case 'boolean':
      return 'boolean_script_field_script_field';
    default:
      return 'string_script_field_script_field';
  }
};
const currentDocumentSelector = state => state.documents[state.currentIdx];
const currentDocumentIsLoadingSelector = state => state.isLoadingDocuments;
const currentErrorSelector = state => {
  var _state$previewRespons;
  return (_state$previewRespons = state.previewResponse) === null || _state$previewRespons === void 0 ? void 0 : _state$previewRespons.error;
};
const isLoadingPreviewSelector = state => state.isLoadingPreview;
const isPreviewAvailableSelector = state => state.isPreviewAvailable;
const concreteFieldsSelector = state => state.concreteFields;
const ScriptFieldComponent = ({
  links,
  placeholder,
  disabled
}) => {
  const {
    validation: {
      setScriptEditorValidation
    }
  } = (0, _preview.useFieldPreviewContext)();
  const monacoEditor = (0, _react.useRef)(null);
  const editorValidationSubscription = (0, _react.useRef)();
  const fieldCurrentValue = (0, _react.useRef)('');
  const {
    controller
  } = (0, _preview.useFieldPreviewContext)();
  const error = (0, _state_utils.useStateSelector)(controller.state$, currentErrorSelector);
  const currentDocument = (0, _state_utils.useStateSelector)(controller.state$, currentDocumentSelector);
  const isFetchingDoc = (0, _state_utils.useStateSelector)(controller.state$, currentDocumentIsLoadingSelector);
  const isLoadingPreview = (0, _state_utils.useStateSelector)(controller.state$, isLoadingPreviewSelector);
  const isPreviewAvailable = (0, _state_utils.useStateSelector)(controller.state$, isPreviewAvailableSelector);
  /**
   * An array of existing concrete fields. If the user gives a name to the runtime
   * field that matches one of the concrete fields, a callout will be displayed
   * to indicate that this runtime field will shadow the concrete field.
   * It is also used to provide the list of field autocomplete suggestions to the code editor.
   */
  const concreteFields = (0, _state_utils.useStateSelector)(controller.state$, concreteFieldsSelector);
  const [validationData$, nextValidationData$] = (0, _shared_imports.useBehaviorSubject)(undefined);
  const [painlessContext, setPainlessContext] = (0, _react.useState)(mapReturnTypeToPainlessContext(_form_schema.schema.type.defaultValue[0].value));
  const currentDocId = currentDocument === null || currentDocument === void 0 ? void 0 : currentDocument._id;
  const suggestionProvider = (0, _react.useMemo)(() => _monaco.PainlessLang.getSuggestionProvider(painlessContext, concreteFields), [painlessContext, concreteFields]);
  const {
    validateFields
  } = (0, _shared_imports.useFormContext)();

  // Listen to formData changes **before** validations are executed
  const onFormDataChange = (0, _react.useCallback)(({
    type
  }) => {
    if (type !== undefined) {
      setPainlessContext(mapReturnTypeToPainlessContext(type[0].value));
    }
    if (isPreviewAvailable) {
      // To avoid a race condition where the validation would run before
      // the context state are updated, we clear the old value of the observable.
      // This way the validationDataProvider() will await until new values come in before resolving
      nextValidationData$(undefined);
    }
  }, [nextValidationData$, isPreviewAvailable]);
  (0, _shared_imports.useFormData)({
    watch: ['type', 'script.source'],
    onChange: onFormDataChange
  });
  const validationDataProvider = (0, _react.useCallback)(async () => {
    const validationData = await (0, _rxjs.firstValueFrom)(validationData$.pipe((0, _rxjs.first)(data => {
      // We first wait to get field preview data
      if (data === undefined) {
        return false;
      }

      // We are not interested in preview data meanwhile it
      // is still making HTTP request
      if (data.isFetchingDoc || data.isLoadingPreview) {
        return false;
      }
      return true;
    })));
    return validationData.error;
  }, [validationData$]);
  const onEditorDidMount = (0, _react.useCallback)(editor => {
    monacoEditor.current = editor;
    if (editorValidationSubscription.current) {
      editorValidationSubscription.current.unsubscribe();
    }
    editorValidationSubscription.current = _monaco.PainlessLang.validation$().subscribe(({
      isValid,
      isValidating,
      errors
    }) => {
      var _errors$0$message, _errors$;
      setScriptEditorValidation({
        isValid,
        isValidating,
        message: (_errors$0$message = (_errors$ = errors[0]) === null || _errors$ === void 0 ? void 0 : _errors$.message) !== null && _errors$0$message !== void 0 ? _errors$0$message : null
      });
    });
  }, [setScriptEditorValidation]);
  const updateMonacoMarkers = (0, _react.useCallback)(markers => {
    var _monacoEditor$current;
    const model = (_monacoEditor$current = monacoEditor.current) === null || _monacoEditor$current === void 0 ? void 0 : _monacoEditor$current.getModel();
    if (model) {
      _monaco.monaco.editor.setModelMarkers(model, _monaco.PainlessLang.ID, markers);
    }
  }, []);
  const displayPainlessScriptErrorInMonaco = (0, _react.useCallback)(painlessError => {
    var _monacoEditor$current2;
    const model = (_monacoEditor$current2 = monacoEditor.current) === null || _monacoEditor$current2 === void 0 ? void 0 : _monacoEditor$current2.getModel();
    if (painlessError.position !== null && Boolean(model)) {
      const {
        offset
      } = painlessError.position;
      // Get the monaco Position (lineNumber and colNumber) from the ES Painless error position
      const errorStartPosition = model.getPositionAt(offset);
      const markerData = (0, _lib.painlessErrorToMonacoMarker)(painlessError, errorStartPosition);
      const errorMarkers = markerData ? [markerData] : [];
      updateMonacoMarkers(errorMarkers);
    }
  }, [updateMonacoMarkers]);

  // Whenever we navigate to a different doc we validate the script
  // field as it could be invalid against the new document.
  (0, _react.useEffect)(() => {
    if (fieldCurrentValue.current.trim() !== '' && currentDocId !== undefined) {
      validateFields(['script.source']);
    }
  }, [currentDocId, validateFields]);
  (0, _react.useEffect)(() => {
    nextValidationData$({
      isFetchingDoc,
      isLoadingPreview,
      error
    });
  }, [nextValidationData$, isFetchingDoc, isLoadingPreview, error]);
  (0, _react.useEffect)(() => {
    if ((error === null || error === void 0 ? void 0 : error.code) === 'PAINLESS_SCRIPT_ERROR') {
      displayPainlessScriptErrorInMonaco(error.error);
    } else if (error === null) {
      updateMonacoMarkers([]);
    }
  }, [error, displayPainlessScriptErrorInMonaco, updateMonacoMarkers]);
  (0, _react.useEffect)(() => {
    return () => {
      if (editorValidationSubscription.current) {
        editorValidationSubscription.current.unsubscribe();
      }
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "script.source",
    validationDataProvider: validationDataProvider,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 5
    }
  }, ({
    value,
    setValue,
    label,
    isValid,
    getErrorsMessages
  }) => {
    let errorMessage = getErrorsMessages();
    if (error) {
      errorMessage = error.error.reason;
    }
    fieldCurrentValue.current = value;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: label,
      hasChildLabel: false,
      id: "runtimeFieldScript",
      error: errorMessage,
      isInvalid: !isValid,
      "data-test-subj": "scriptFieldRow",
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.editor.form.source.scriptFieldHelpText",
        defaultMessage: "Runtime fields without a script retrieve values from {source}. If the field doesn't exist in _source, a search request returns no value. {learnMoreLink}",
        values: {
          learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: links.runtimePainless,
            target: "_blank",
            external: true,
            "data-test-subj": "painlessSyntaxLearnMoreLink",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 252,
              columnNumber: 23
            }
          }, _i18n.i18n.translate('indexPatternFieldEditor.editor.form.script.learnMoreLinkText', {
            defaultMessage: 'Learn about script syntax.'
          })),
          source: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 266,
              columnNumber: 29
            }
          }, '_source')
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 247,
          columnNumber: 17
        }
      }),
      fullWidth: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 239,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_shared_imports.CodeEditor, {
      languageId: _monaco.PainlessLang.ID,
      suggestionProvider: suggestionProvider
      // 99% width allows the editor to resize horizontally. 100% prevents it from resizing.
      ,
      width: "99%",
      height: "210px",
      value: value,
      onChange: setValue,
      editorDidMount: onEditorDidMount,
      options: {
        fontSize: 12,
        minimap: {
          enabled: false
        },
        scrollBeyondLastLine: false,
        wordWrap: 'on',
        wrappingIndent: 'indent',
        automaticLayout: true,
        suggest: {
          snippetsPreventQuickSuggestions: false
        },
        readOnly: disabled
      },
      "data-test-subj": "scriptField",
      "aria-label": _i18n.i18n.translate('indexPatternFieldEditor.editor.form.scriptEditorAriaLabel', {
        defaultMessage: 'Script editor'
      }),
      placeholder: placeholder,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 272,
        columnNumber: 15
      }
    })));
  });
};
const ScriptField = exports.ScriptField = /*#__PURE__*/_react.default.memo(ScriptFieldComponent);