"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataViewEditorPlugin = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _open_editor = require("./open_editor");
var _data_view_editor = require("./components/data_view_editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_editor/public/plugin.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class DataViewEditorPlugin {
  setup(core, plugins) {
    return {};
  }
  start(core, plugins) {
    const {
      application,
      uiSettings,
      docLinks,
      http,
      notifications,
      overlays
    } = core;
    const {
      data,
      dataViews
    } = plugins;
    return {
      /**
       * Data view editor flyout via function interface
       * @param DataViewEditorProps - data view editor config
       * @returns method to close editor
       */
      openEditor: (0, _open_editor.getEditorOpener)({
        core,
        dataViews,
        searchClient: data.search.search
      }),
      /**
       * Data view editor flyout via react component
       * @param DataViewEditorProps - data view editor config
       * @returns JSX.Element
       */
      IndexPatternEditorComponent: props => /*#__PURE__*/_react.default.createElement(_data_view_editor.DataViewEditor, (0, _extends2.default)({
        services: {
          uiSettings,
          docLinks,
          http,
          notifications,
          application,
          overlays,
          dataViews,
          searchClient: data.search.search
        }
      }, props, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 51,
          columnNumber: 9
        }
      })),
      /**
       * Convenience method to determine whether the user can create or edit edit data views.
       *
       * @returns boolean
       */
      userPermissions: {
        editDataView: () => dataViews.getCanSaveSync()
      },
      /**
       * Helper method to generate a new data view editor service.
       * @returns DataViewEditorService
       */
      dataViewEditorServiceFactory: async () => {
        const module = await Promise.resolve().then(() => _interopRequireWildcard(require('./data_view_editor_service_lazy')));
        return module;
      }
    };
  }
}
exports.DataViewEditorPlugin = DataViewEditorPlugin;