"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InternalDashboardTopNav = InternalDashboardTopNav;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _useUnmount = _interopRequireDefault(require("react-use/lib/useUnmount"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _i18nReact = require("@kbn/i18n-react");
var _managedContentBadge = require("@kbn/managed-content-badge");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/presentation-util-plugin/public");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _constants = require("../../common/constants");
var _use_dashboard_api = require("../dashboard_api/use_dashboard_api");
var _dashboard_app_strings = require("../dashboard_app/_dashboard_app_strings");
var _dashboard_mount_context = require("../dashboard_app/hooks/dashboard_mount_context");
var _use_dashboard_menu_items = require("../dashboard_app/top_nav/use_dashboard_menu_items");
var _open_settings_flyout = require("../dashboard_renderer/settings/open_settings_flyout");
var _dashboard_recently_accessed_service = require("../services/dashboard_recently_accessed_service");
var _kibana_services = require("../services/kibana_services");
var _get_dashboard_capabilities = require("../utils/get_dashboard_capabilities");
var _urls = require("../utils/urls");
var _dashboard_favorite_button = require("./dashboard_favorite_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/dashboard/public/dashboard_top_nav/internal_dashboard_top_nav.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LabsFlyout = (0, _public.withSuspense)(_public.LazyLabsFlyout, null);
function InternalDashboardTopNav({
  customLeadingBreadCrumbs = [],
  embedSettings,
  forceHideUnifiedSearch,
  redirectTo,
  setCustomHeaderActionMenu,
  showBorderBottom = true,
  showResetChange = true
}) {
  const [isChromeVisible, setIsChromeVisible] = (0, _react.useState)(false);
  const [isLabsShown, setIsLabsShown] = (0, _react.useState)(false);
  const dashboardTitleRef = (0, _react.useRef)(null);
  const isLabsEnabled = (0, _react.useMemo)(() => _kibana_services.coreServices.uiSettings.get(_constants.UI_SETTINGS.ENABLE_LABS_UI), []);
  const {
    setHeaderActionMenu,
    onAppLeave
  } = (0, _dashboard_mount_context.useDashboardMountContext)();
  const dashboardApi = (0, _use_dashboard_api.useDashboardApi)();
  const [allDataViews, fullScreenMode, hasUnsavedChanges, lastSavedId, query, title, viewMode] = (0, _presentationPublishing.useBatchedPublishingSubjects)(dashboardApi.dataViews$, dashboardApi.fullScreenMode$, dashboardApi.hasUnsavedChanges$, dashboardApi.savedObjectId$, dashboardApi.query$, dashboardApi.title$, dashboardApi.viewMode$);
  const [savedQueryId, setSavedQueryId] = (0, _react.useState)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const dashboardTitle = (0, _react.useMemo)(() => {
    return (0, _dashboard_app_strings.getDashboardTitle)(title, viewMode, !lastSavedId);
  }, [title, viewMode, lastSavedId]);
  const styles = (0, _use_memo_css.useMemoCss)(topNavStyles);

  /**
   * focus on the top header when title or view mode is changed
   */
  (0, _react.useEffect)(() => {
    var _dashboardTitleRef$cu;
    (_dashboardTitleRef$cu = dashboardTitleRef.current) === null || _dashboardTitleRef$cu === void 0 ? void 0 : _dashboardTitleRef$cu.focus();
  }, [title, viewMode]);

  /*
   * Manage chrome visibility when dashboard is in print mode.
   */
  (0, _react.useEffect)(() => {
    if (!embedSettings && viewMode === 'print') _kibana_services.coreServices.chrome.setIsVisible(false);
  }, [embedSettings, viewMode]);

  /**
   * populate recently accessed, and set is chrome visible.
   */
  (0, _react.useEffect)(() => {
    const subscription = _kibana_services.coreServices.chrome.getIsVisible$().subscribe(visible => setIsChromeVisible(visible));
    if (lastSavedId && title) {
      const fullEditPath = (0, _urls.getFullEditPath)(lastSavedId, viewMode === 'edit');
      _kibana_services.coreServices.chrome.recentlyAccessed.add(fullEditPath, title, lastSavedId);
      (0, _dashboard_recently_accessed_service.getDashboardRecentlyAccessedService)().add(fullEditPath, title, lastSavedId); // used to sort the listing table
    }
    return () => subscription.unsubscribe();
  }, [lastSavedId, viewMode, title]);

  /**
   * Set breadcrumbs to dashboard title when dashboard's title or view mode changes
   */
  (0, _react.useEffect)(() => {
    const dashboardTitleBreadcrumbs = [{
      text: viewMode === 'edit' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, dashboardTitle, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        tabIndex: 0,
        role: "button",
        "aria-label": _dashboard_app_strings.topNavStrings.settings.description,
        size: "s",
        type: "pencil",
        onClick: () => (0, _open_settings_flyout.openSettingsFlyout)(dashboardApi),
        css: styles.updateIcon,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 148,
          columnNumber: 15
        }
      })) : dashboardTitle,
      'aria-label': dashboardTitle
    }];
    if (_kibana_services.serverlessService) {
      // set serverless breadcrumbs if available,
      // set only the dashboardTitleBreadcrumbs because the main breadcrumbs automatically come as part of the navigation config
      _kibana_services.serverlessService.setBreadcrumbs(dashboardTitleBreadcrumbs);
    } else {
      /**
       * non-serverless regular breadcrumbs
       * Dashboard embedded in other plugins (e.g. SecuritySolution)
       * will have custom leading breadcrumbs for back to their app.
       **/
      _kibana_services.coreServices.chrome.setBreadcrumbs(customLeadingBreadCrumbs.concat([{
        text: (0, _dashboard_app_strings.getDashboardBreadcrumb)(),
        'data-test-subj': 'dashboardListingBreadcrumb',
        onClick: () => {
          redirectTo({
            destination: 'listing'
          });
        }
      }, ...dashboardTitleBreadcrumbs]), {
        project: {
          value: dashboardTitleBreadcrumbs
        }
      });
    }
  }, [redirectTo, dashboardTitle, dashboardApi, viewMode, customLeadingBreadCrumbs, styles.updateIcon]);

  /**
   * Build app leave handler whenever hasUnsavedChanges changes
   */
  (0, _react.useEffect)(() => {
    onAppLeave(actions => {
      return actions.default();
    });
    return () => {
      // reset on app leave handler so leaving from the listing page doesn't trigger a confirmation
      onAppLeave(actions => actions.default());
    };
  }, [onAppLeave, hasUnsavedChanges, viewMode]);
  const visibilityProps = (0, _react.useMemo)(() => {
    const shouldShowNavBarComponent = forceShow => (forceShow || isChromeVisible) && !fullScreenMode;
    const shouldShowFilterBar = forceHide => !forceHide && (_kibana_services.dataService.query.filterManager.getFilters().length > 0 || !fullScreenMode);
    const showTopNavMenu = shouldShowNavBarComponent(Boolean(embedSettings === null || embedSettings === void 0 ? void 0 : embedSettings.forceShowTopNavMenu));
    const showQueryInput = Boolean(forceHideUnifiedSearch) ? false : shouldShowNavBarComponent(Boolean((embedSettings === null || embedSettings === void 0 ? void 0 : embedSettings.forceShowQueryInput) || viewMode === 'edit'));
    const showDatePicker = Boolean(forceHideUnifiedSearch) ? false : shouldShowNavBarComponent(Boolean(embedSettings === null || embedSettings === void 0 ? void 0 : embedSettings.forceShowDatePicker));
    const showFilterBar = shouldShowFilterBar(Boolean(embedSettings === null || embedSettings === void 0 ? void 0 : embedSettings.forceHideFilterBar));
    const showQueryBar = showQueryInput || showDatePicker || showFilterBar;
    const showSearchBar = showQueryBar || showFilterBar;
    return {
      showTopNavMenu,
      showSearchBar,
      showFilterBar,
      showQueryInput,
      showDatePicker
    };
  }, [embedSettings, forceHideUnifiedSearch, fullScreenMode, isChromeVisible, viewMode]);
  const maybeRedirect = (0, _react.useCallback)(result => {
    if (!result) return;
    const {
      redirectRequired,
      id
    } = result;
    if (redirectRequired) {
      redirectTo({
        id,
        editMode: true,
        useReplace: true,
        destination: 'dashboard'
      });
    }
  }, [redirectTo]);
  const {
    viewModeTopNavConfig,
    editModeTopNavConfig
  } = (0, _use_dashboard_menu_items.useDashboardMenuItems)({
    isLabsShown,
    setIsLabsShown,
    maybeRedirect,
    showResetChange
  });
  (0, _useUnmount.default)(() => {
    dashboardApi.clearOverlays();
  });
  const badges = (0, _react.useMemo)(() => {
    const allBadges = [];
    if (hasUnsavedChanges && viewMode === 'edit') {
      allBadges.push({
        'data-test-subj': 'dashboardUnsavedChangesBadge',
        badgeText: _dashboard_app_strings.unsavedChangesBadgeStrings.getUnsavedChangedBadgeText(),
        title: '',
        color: '#F6E58D',
        toolTipProps: {
          content: _dashboard_app_strings.unsavedChangesBadgeStrings.getUnsavedChangedBadgeToolTipContent(),
          position: 'bottom'
        }
      });
    }
    const {
      showWriteControls
    } = (0, _get_dashboard_capabilities.getDashboardCapabilities)();
    if (showWriteControls && dashboardApi.isManaged) {
      const badgeProps = {
        ...(0, _managedContentBadge.getManagedContentBadge)(_dashboard_app_strings.dashboardManagedBadge.getBadgeAriaLabel()),
        onClick: () => setIsPopoverOpen(!isPopoverOpen),
        onClickAriaLabel: _dashboard_app_strings.dashboardManagedBadge.getBadgeAriaLabel(),
        iconOnClick: () => setIsPopoverOpen(!isPopoverOpen),
        iconOnClickAriaLabel: _dashboard_app_strings.dashboardManagedBadge.getBadgeAriaLabel()
      };
      allBadges.push({
        renderCustomBadge: ({
          badgeText
        }) => {
          const badgeButton = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({}, badgeProps, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 294,
              columnNumber: 31
            }
          }), badgeText);
          return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
            button: badgeButton,
            isOpen: isPopoverOpen,
            closePopover: () => setIsPopoverOpen(false),
            panelStyle: {
              maxWidth: 250
            },
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 296,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "dashboard.managedContentPopoverButton",
            defaultMessage: "Elastic manages this dashboard. {Duplicate} it to make changes.",
            values: {
              Duplicate: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
                id: "dashboardManagedContentPopoverButton",
                onClick: () => {
                  dashboardApi.runInteractiveSave().then(result => maybeRedirect(result));
                },
                "aria-label": _dashboard_app_strings.dashboardManagedBadge.getDuplicateButtonAriaLabel(),
                __self: this,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 307,
                  columnNumber: 21
                }
              }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
                id: "dashboard.managedContentPopoverButtonText",
                defaultMessage: "Duplicate",
                __self: this,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 314,
                  columnNumber: 23
                }
              }))
            },
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 302,
              columnNumber: 15
            }
          }));
        },
        badgeText: badgeProps.badgeText
      });
    }
    return allBadges;
  }, [hasUnsavedChanges, viewMode, isPopoverOpen, dashboardApi, maybeRedirect]);
  const setFavoriteButtonMountPoint = (0, _react.useCallback)(mountPoint => {
    if (mountPoint) {
      return _kibana_services.coreServices.chrome.setBreadcrumbsAppendExtension({
        content: mountPoint,
        order: 0
      });
    }
  }, []);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles.container,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 344,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 345,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    id: "dashboardTitle",
    ref: dashboardTitleRef,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 346,
      columnNumber: 9
    }
  }, `${(0, _dashboard_app_strings.getDashboardBreadcrumb)()} - ${dashboardTitle}`)), /*#__PURE__*/_react.default.createElement(_kibana_services.navigationService.ui.TopNavMenu, (0, _extends2.default)({}, visibilityProps, {
    query: query,
    badges: badges,
    screenTitle: title,
    useDefaultBehaviors: true,
    savedQueryId: savedQueryId,
    indexPatterns: allDataViews !== null && allDataViews !== void 0 ? allDataViews : [],
    allowSavingQueries: true,
    appName: _constants.DASHBOARD_APP_ID,
    visible: viewMode !== 'print',
    setMenuMountPoint: embedSettings || fullScreenMode ? setCustomHeaderActionMenu !== null && setCustomHeaderActionMenu !== void 0 ? setCustomHeaderActionMenu : undefined : setHeaderActionMenu,
    config: visibilityProps.showTopNavMenu ? viewMode === 'edit' ? editModeTopNavConfig : viewModeTopNavConfig : undefined,
    onQuerySubmit: (_payload, isUpdate) => {
      if (isUpdate === false) {
        dashboardApi.forceRefresh();
      }
    },
    onSavedQueryIdChange: setSavedQueryId,
    useBackgroundSearchButton: _kibana_services.dataService.search.isBackgroundSearchEnabled && (0, _get_dashboard_capabilities.getDashboardCapabilities)().storeSearchSession,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 351,
      columnNumber: 7
    }
  })), viewMode !== 'print' && isLabsEnabled && isLabsShown ? /*#__PURE__*/_react.default.createElement(LabsFlyout, {
    solutions: ['dashboard'],
    onClose: () => setIsLabsShown(false),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 386,
      columnNumber: 9
    }
  }) : null, showBorderBottom && /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 388,
      columnNumber: 28
    }
  }), /*#__PURE__*/_react.default.createElement(_reactKibanaMount.MountPointPortal, {
    setMountPoint: setFavoriteButtonMountPoint,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 389,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_dashboard_favorite_button.DashboardFavoriteButton, {
    dashboardId: lastSavedId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 390,
      columnNumber: 9
    }
  })));
}
const topNavStyles = {
  container: ({
    euiTheme
  }) => (0, _react2.css)({
    '.kbnBody &': {
      width: '100%',
      position: 'sticky',
      zIndex: euiTheme.levels.mask,
      top: `var(--kbn-application--sticky-headers-offset, 0px)`,
      background: euiTheme.colors.backgroundBasePlain,
      [`@media (max-width: ${euiTheme.breakpoint.m}px)`]: {
        position: 'unset' // on smaller screens, the top nav should not be sticky
      }
    }
  }),
  updateIcon: ({
    euiTheme
  }) => (0, _react2.css)({
    '.kbnBody &': {
      marginLeft: euiTheme.size.xs,
      marginTop: `calc(-1 * ${euiTheme.size.xxs})`,
      cursor: 'pointer'
    }
  })
};