"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppRouter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _rxjs = require("rxjs");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _coreApplicationBrowser = require("@kbn/core-application-browser");
var _sharedUxErrorBoundary = require("@kbn/shared-ux-error-boundary");
var _app_container = require("./app_container");
var _scoped_history = require("../scoped_history");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/application/browser-internal/src/ui/app_router.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AppRouter = ({
  history,
  analytics,
  mounters,
  theme$,
  setAppLeaveHandler,
  setAppActionMenu,
  appStatuses$,
  setIsMounting,
  hasCustomBranding$
}) => {
  const appStatuses = (0, _useObservable.default)(appStatuses$, new Map());
  const createScopedHistory = (0, _react.useMemo)(() => appPath => new _scoped_history.CoreScopedHistory(history, appPath), [history]);
  const showPlainSpinner = (0, _useObservable.default)(hasCustomBranding$ !== null && hasCustomBranding$ !== void 0 ? hasCustomBranding$ : _rxjs.EMPTY, false);
  return /*#__PURE__*/_react.default.createElement(_sharedUxErrorBoundary.KibanaErrorBoundaryProvider, {
    analytics: analytics,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxErrorBoundary.KibanaErrorBoundary, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }, [...mounters].map(([appId, mounter]) => /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    key: mounter.appRoute,
    path: mounter.appRoute,
    exact: mounter.exactRoute,
    render: ({
      match: {
        path
      }
    }) => {
      var _appStatuses$get;
      return /*#__PURE__*/_react.default.createElement(_app_container.AppContainer, {
        appPath: path,
        appStatus: (_appStatuses$get = appStatuses.get(appId)) !== null && _appStatuses$get !== void 0 ? _appStatuses$get : _coreApplicationBrowser.AppStatus.inaccessible,
        createScopedHistory: createScopedHistory,
        appId,
        mounter,
        setAppLeaveHandler,
        setAppActionMenu,
        setIsMounting,
        theme$,
        showPlainSpinner,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 74,
          columnNumber: 19
        }
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/app/:appId",
    render: ({
      match: {
        params: {
          appId
        },
        url
      }
    }) => {
      var _appStatuses$get2;
      // the id/mounter retrieval can be removed once #76348 is addressed
      const [id, mounter] = mounters.has(appId) ? [appId, mounters.get(appId)] : [];
      return /*#__PURE__*/_react.default.createElement(_app_container.AppContainer, {
        appPath: url,
        appId: id !== null && id !== void 0 ? id : appId,
        appStatus: (_appStatuses$get2 = appStatuses.get(appId)) !== null && _appStatuses$get2 !== void 0 ? _appStatuses$get2 : _coreApplicationBrowser.AppStatus.inaccessible,
        createScopedHistory: createScopedHistory,
        mounter,
        setAppLeaveHandler,
        setAppActionMenu,
        setIsMounting,
        theme$,
        showPlainSpinner,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 19
        }
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 13
    }
  })))));
};
exports.AppRouter = AppRouter;