"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PlayButton = PlayButton;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _time_slider_strings = require("./time_slider_strings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/controls/public/controls/timeslider_control/components/play_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function PlayButton(props) {
  if (props.waitForControlOutputConsumersToLoad$ === undefined || props.disablePlayButton && props.viewMode === 'view') {
    return null;
  }
  const Button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: props.isPaused ? props.onPlay : props.onPause,
    disabled: props.disablePlayButton,
    iconType: props.isPaused ? 'playFilled' : 'pause',
    size: "s",
    display: "fill",
    "aria-label": _time_slider_strings.TimeSliderStrings.control.getPlayButtonAriaLabel(props.isPaused),
    css: styles.icon,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  });
  return props.disablePlayButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    display: "block",
    content: _time_slider_strings.TimeSliderStrings.control.getPlayButtonDisabledTooltip(),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  }, Button) : Button;
}
const styles = {
  icon: ({
    euiTheme
  }) => (0, _react2.css)`
    height: 100%;
    &:enabled {
      background-color: ${euiTheme.colors.primary} !important;
    }
  `
};