"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DragHandle = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/controls/public/control_group/components/drag_handle.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const dragHandleStyles = (0, _react2.css)({
  cursor: 'grab',
  lineHeight: '0' // Vertically center the grab handle
});
const DragHandle = ({
  isEditable,
  controlTitle = '',
  ...rest
}) => {
  if (!isEditable) return null;
  return /*#__PURE__*/_react.default.createElement("button", (0, _extends2.default)({}, rest, {
    "aria-label": _i18n.i18n.translate('controls.controlGroup.ariaActions.moveControlButtonAction', {
      defaultMessage: 'Move control {controlTitle}',
      values: {
        controlTitle
      }
    }),
    css: dragHandleStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "grabHorizontal",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }));
};
exports.DragHandle = DragHandle;